/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0005\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u0012\u0010\f\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u0012\u0010\f\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007\u001a\n\u0010\r\u001a\u00020\u0007*\u00020\u0005\u001a\u0012\u0010\r\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0005\u001a\u0012\u0010\u000f\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007\u001a\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u001c\u0010\u0015\u001a\u00020\u0012*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0017"}, d2={"EmptyByteArray", "", "getEmptyByteArray", "()[B", "bytes", "Ljava/io/InputStream;", "count", "", "i16", "", "Ljava/io/OutputStream;", "value", "i32", "i8", "readAvailableChunk", "readExactBytes", "size", "stringz", "", "charset", "Ljava/nio/charset/Charset;", "stringzTrim", "stripTailZeros", "jtransc-utils_main"})
public final class StreamKt {
    @NotNull
    private static final byte[] EmptyByteArray = new byte[0];

    public static final void i8(@NotNull OutputStream $receiver, int value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.write(value);
    }

    public static final void i16(@NotNull OutputStream $receiver, int value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.write(value >>> 8 & 0xFF);
        $receiver.write(value >>> 0 & 0xFF);
    }

    public static final void i32(@NotNull OutputStream $receiver, int value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.write(value >>> 24 & 0xFF);
        $receiver.write(value >>> 16 & 0xFF);
        $receiver.write(value >>> 8 & 0xFF);
        $receiver.write(value >>> 0 & 0xFF);
    }

    public static final int i8(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (byte)($receiver.read() & 0xFF);
    }

    public static final int i16(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int h = StreamKt.i8($receiver);
        int l = StreamKt.i8($receiver);
        return (short)(h << 8 | l << 0);
    }

    public static final int i32(@NotNull InputStream $receiver, int value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int h = StreamKt.i16($receiver);
        int l = StreamKt.i16($receiver);
        return h << 16 | l << 0;
    }

    @NotNull
    public static final byte[] bytes(@NotNull InputStream $receiver, int count) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] out = new byte[count];
        $receiver.read(out);
        return out;
    }

    @NotNull
    public static final byte[] stripTailZeros(@NotNull byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int index = ArraysKt.indexOf((byte[])$receiver, (byte)0);
        byte[] byArray = Arrays.copyOf($receiver, index >= 0 ? index : $receiver.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOf(this, if (\u2026 0) index else this.size)");
        return byArray;
    }

    @NotNull
    public static final String stringz(@NotNull InputStream $receiver, int count, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        byte[] byArray = StreamKt.stripTailZeros(StreamKt.bytes($receiver, count));
        return new String(byArray, charset);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String stringz$default(InputStream inputStream, int n, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return StreamKt.stringz(inputStream, n, charset);
    }

    @NotNull
    public static final String stringzTrim(@NotNull InputStream $receiver, int count, @NotNull Charset charset) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        String string2 = string = StreamKt.stringz($receiver, count, charset);
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String stringzTrim$default(InputStream inputStream, int n, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return StreamKt.stringzTrim(inputStream, n, charset);
    }

    @NotNull
    public static final byte[] getEmptyByteArray() {
        return EmptyByteArray;
    }

    @NotNull
    public static final byte[] readAvailableChunk(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.available() <= 0) {
            return EmptyByteArray;
        }
        byte[] out = new byte[$receiver.available()];
        int readed = $receiver.read(out, 0, out.length);
        return ArraysKt.sliceArray((byte[])out, (IntRange)RangesKt.until((int)0, (int)readed));
    }

    @NotNull
    public static final byte[] readExactBytes(@NotNull InputStream $receiver, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] out = new byte[size];
        int offset = 0;
        int remaining = size;
        while (remaining > 0) {
            int read2 = $receiver.read(out, offset, remaining);
            remaining -= read2;
            offset += read2;
        }
        return out;
    }
}

