/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.json;

import com.jtransc.json.JsonReaderException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0001\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0016J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0003J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001d\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\u0016J\u0015\u0010 \u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u0016\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/jtransc/json/JsonReader;", "", "str", "", "(Ljava/lang/String;)V", "eof", "", "getEof", "()Z", "length", "", "getLength", "()I", "offset", "getOffset", "setOffset", "(I)V", "getStr", "()Ljava/lang/String;", "expect", "expected", "expectch", "", "", "expectedError", "", "found", "peek", "count", "peekch", "read", "readch", "trych", "(C)Ljava/lang/Character;", "jtransc-utils_main"})
public final class JsonReader {
    private int offset;
    @NotNull
    private final String str;

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final int getLength() {
        return this.str.length();
    }

    public final boolean getEof() {
        return this.offset >= this.getLength();
    }

    public final char peekch() {
        return this.str.charAt(this.offset);
    }

    public final char readch() {
        int n = this.offset;
        this.offset = n + 1;
        return this.str.charAt(n);
    }

    @NotNull
    public final String peek(int count) {
        String string = this.str;
        int n = this.offset;
        int n2 = Math.min(this.getLength(), this.offset + count);
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String read(int count) {
        String out = this.peek(count);
        this.offset += count;
        return out;
    }

    @NotNull
    public final String expect(@NotNull String expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        String c = this.read(expected.length());
        if (Intrinsics.areEqual((Object)c, (Object)expected) ^ true) {
            Void void_ = this.expectedError(expected, c);
            throw null;
        }
        return c;
    }

    @Nullable
    public final Character trych(char expected) {
        return this.peekch() == expected ? Character.valueOf(this.readch()) : null;
    }

    public final char expectch(char expected) {
        char c = this.peekch();
        if (c != expected) {
            Void void_ = this.expectedError(String.valueOf(expected), String.valueOf(c));
            throw null;
        }
        return this.readch();
    }

    public final char expectch(@NotNull Set<Character> expected) {
        Intrinsics.checkParameterIsNotNull(expected, (String)"expected");
        char c = this.peekch();
        if (expected.contains(Character.valueOf(c)) ^ true) {
            Void void_ = this.expectedError(String.valueOf(expected), String.valueOf(c));
            throw null;
        }
        return this.readch();
    }

    @NotNull
    public final Void expectedError(@NotNull String expected, @NotNull String found) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        Intrinsics.checkParameterIsNotNull((Object)found, (String)"found");
        throw (Throwable)new JsonReaderException("Expected '" + expected + "' but found '" + found + "' at " + this.offset);
    }

    @NotNull
    public final Void expectedError(@NotNull String expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        throw (Throwable)new JsonReaderException("Expected '" + expected + "' at " + this.offset);
    }

    @NotNull
    public final String getStr() {
        return this.str;
    }

    public JsonReader(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        this.str = str;
    }
}

