/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.json;

import com.jtransc.json.JsonReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u001a\u0012\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0007\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u0006*\u00020\u0007\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0007\u001a\u0018\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000e*\u00020\u0007\u001a\n\u0010\u0010\u001a\u00020\u000f*\u00020\u0007\u001a\n\u0010\u0011\u001a\u00020\t*\u00020\u0007\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u0007\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"COMMA_OR_CLOSE_BRACKETS", "", "", "COMMA_OR_CLOSE_CURLY_BRACES", "readArray", "", "", "Lcom/jtransc/json/JsonReader;", "readFalse", "", "readNull", "readNumber", "", "readObject", "", "", "readString", "readTrue", "readValue", "skipSpaces", "", "jtransc-utils_main"})
public final class ReaderKt {
    private static final Set<Character> COMMA_OR_CLOSE_CURLY_BRACES = SetsKt.setOf((Object[])new Character[]{Character.valueOf(','), Character.valueOf('}')});
    private static final Set<Character> COMMA_OR_CLOSE_BRACKETS = SetsKt.setOf((Object[])new Character[]{Character.valueOf(','), Character.valueOf(']')});

    public static final void skipSpaces(@NotNull JsonReader $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        block3: while (!$receiver.getEof()) {
            switch ($receiver.peekch()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    $receiver.readch();
                    continue block3;
                }
            }
            break;
        }
    }

    @Nullable
    public static final Object readValue(@NotNull JsonReader $receiver) {
        Object object;
        char c;
        char v;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ReaderKt.skipSpaces($receiver);
        char c2 = v = $receiver.peekch();
        if (c2 == '-' || c2 == '.' || '0' <= (c = c2) && c <= '9') {
            object = ReaderKt.readNumber($receiver);
        } else if (c2 == '\"') {
            object = ReaderKt.readString($receiver);
        } else if (c2 == '{') {
            object = ReaderKt.readObject($receiver);
        } else if (c2 == '[') {
            object = ReaderKt.readArray($receiver);
        } else if (c2 == 't') {
            object = ReaderKt.readTrue($receiver);
        } else if (c2 == 'f') {
            object = ReaderKt.readFalse($receiver);
        } else if (c2 == 'n') {
            object = ReaderKt.readNull($receiver);
        } else {
            Void void_ = $receiver.expectedError("Json value", String.valueOf(v));
            throw null;
        }
        Double result2 = object;
        ReaderKt.skipSpaces($receiver);
        return result2;
    }

    public static final boolean readTrue(@NotNull JsonReader $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean $receiver2 = bl = true;
        ReaderKt.skipSpaces($receiver);
        $receiver.expect("true");
        ReaderKt.skipSpaces($receiver);
        return bl;
    }

    public static final boolean readFalse(@NotNull JsonReader $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean $receiver2 = bl = false;
        ReaderKt.skipSpaces($receiver);
        $receiver.expect("false");
        ReaderKt.skipSpaces($receiver);
        return bl;
    }

    @Nullable
    public static final Object readNull(@NotNull JsonReader $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object var1_1 = null;
        Void $receiver2 = var1_1;
        ReaderKt.skipSpaces($receiver);
        $receiver.expect("null");
        ReaderKt.skipSpaces($receiver);
        return var1_1;
    }

    public static final double readNumber(@NotNull JsonReader $receiver) {
        char c;
        char ch;
        char c2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ReaderKt.skipSpaces($receiver);
        String out = "";
        while (!$receiver.getEof() && ((c2 = (ch = $receiver.peekch())) == '+' || c2 == '-' || c2 == 'e' || c2 == 'E' || c2 == '.' || '0' <= (c = c2) && c <= '9')) {
            out = out + $receiver.readch();
        }
        ReaderKt.skipSpaces($receiver);
        return Double.parseDouble(out);
    }

    @NotNull
    public static final String readString(@NotNull JsonReader $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String out = "";
        ReaderKt.skipSpaces($receiver);
        $receiver.expectch('\"');
        block15: while (!$receiver.getEof()) {
            char c = $receiver.peekch();
            block0 : switch (c) {
                case '\\': {
                    $receiver.readch();
                    char k = $receiver.readch();
                    switch (k) {
                        case '\"': {
                            out = out + '\"';
                            break block0;
                        }
                        case '\\': {
                            out = out + '\\';
                            break block0;
                        }
                        case '/': {
                            out = out + '/';
                            break block0;
                        }
                        case 'b': {
                            out = out + '\b';
                            break block0;
                        }
                        case 'f': {
                            out = out + '\f';
                            break block0;
                        }
                        case 'n': {
                            out = out + '\n';
                            break block0;
                        }
                        case 'r': {
                            out = out + '\r';
                            break block0;
                        }
                        case 't': {
                            out = out + '\t';
                            break block0;
                        }
                        case 'u': {
                            out = out + Integer.parseInt($receiver.read(4), 16);
                            break block0;
                        }
                    }
                    Void void_ = $receiver.expectedError("Expected escape sequence");
                    throw null;
                }
                case '\"': {
                    break block15;
                }
                default: {
                    out = out + $receiver.readch();
                }
            }
        }
        $receiver.expectch('\"');
        ReaderKt.skipSpaces($receiver);
        return out;
    }

    @NotNull
    public static final Map<String, Object> readObject(@NotNull JsonReader $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        HashMap out = new HashMap();
        ReaderKt.skipSpaces($receiver);
        $receiver.expectch('{');
        ReaderKt.skipSpaces($receiver);
        do {
            ReaderKt.skipSpaces($receiver);
            if ($receiver.trych('}') != null) break;
            ReaderKt.skipSpaces($receiver);
            String key = ReaderKt.readString($receiver);
            ReaderKt.skipSpaces($receiver);
            $receiver.expectch(':');
            ReaderKt.skipSpaces($receiver);
            Object value = ReaderKt.readValue($receiver);
            ReaderKt.skipSpaces($receiver);
            Map map = out;
            Object object = value;
            map.put(key, object);
        } while ($receiver.expectch(COMMA_OR_CLOSE_CURLY_BRACES) == ',');
        ReaderKt.skipSpaces($receiver);
        return out;
    }

    @NotNull
    public static final List<Object> readArray(@NotNull JsonReader $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ArrayList out = new ArrayList();
        ReaderKt.skipSpaces($receiver);
        $receiver.expectch('[');
        ReaderKt.skipSpaces($receiver);
        do {
            ReaderKt.skipSpaces($receiver);
            if ($receiver.trych(']') != null) break;
            ReaderKt.skipSpaces($receiver);
            Object value = ReaderKt.readValue($receiver);
            ReaderKt.skipSpaces($receiver);
            Collection collection = out;
            collection.add(value);
        } while ($receiver.expectch(COMMA_OR_CLOSE_BRACKETS) == ',');
        ReaderKt.skipSpaces($receiver);
        return out;
    }
}

