/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.json;

import com.jtransc.json.JsonWriter;
import com.jtransc.json.JsonWriterException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"writeArray", "Lcom/jtransc/json/JsonWriter;", "list", "", "writeNumber", "value", "", "writeObject", "obj", "", "writeString", "str", "", "writeValue", "", "jtransc-utils_main"})
public final class WriterKt {
    @NotNull
    public static final JsonWriter writeValue(@NotNull JsonWriter $receiver, @Nullable Object value) {
        JsonWriter jsonWriter;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        JsonWriter $receiver2 = jsonWriter = $receiver;
        Object object = value;
        if (Intrinsics.areEqual((Object)object, null)) {
            $receiver2.write("null");
        } else if (Intrinsics.areEqual((Object)object, (Object)true)) {
            $receiver2.write("true");
        } else if (Intrinsics.areEqual((Object)object, (Object)false)) {
            $receiver2.write("false");
        } else if (object instanceof Map) {
            WriterKt.writeObject($receiver2, (Map)value);
        } else if (object instanceof Iterable) {
            WriterKt.writeArray($receiver2, (Iterable)value);
        } else if (object instanceof String) {
            WriterKt.writeString($receiver2, (String)value);
        } else if (object instanceof Double) {
            WriterKt.writeNumber($receiver2, ((Number)value).doubleValue());
        } else if (object instanceof Number) {
            WriterKt.writeNumber($receiver2, ((Number)value).doubleValue());
        } else {
            throw (Throwable)new JsonWriterException("Don't know how to serialize " + value);
        }
        return jsonWriter;
    }

    @NotNull
    public static final JsonWriter writeNumber(@NotNull JsonWriter $receiver, double value) {
        JsonWriter jsonWriter;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        JsonWriter $receiver2 = jsonWriter = $receiver;
        $receiver2.write(String.valueOf(value));
        return jsonWriter;
    }

    @NotNull
    public static final JsonWriter writeString(@NotNull JsonWriter $receiver, @NotNull String str) {
        JsonWriter jsonWriter;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        JsonWriter $receiver2 = jsonWriter = $receiver;
        $receiver2.write('\"');
        CharIterator charIterator = StringsKt.iterator((CharSequence)str);
        while (charIterator.hasNext()) {
            char ch = charIterator.nextChar();
            char c = ch;
            if (c == '\"') {
                $receiver2.write("\\\"");
                continue;
            }
            if (c == '\\') {
                $receiver2.write("\\\\");
                continue;
            }
            if (c == '/') {
                $receiver2.write("\\/");
                continue;
            }
            if (c == '\b') {
                $receiver2.write("\\b");
                continue;
            }
            if (c == '\f') {
                $receiver2.write("\\f");
                continue;
            }
            if (c == '\n') {
                $receiver2.write("\\n");
                continue;
            }
            if (c == '\r') {
                $receiver2.write("\\r");
                continue;
            }
            if (c == '\t') {
                $receiver2.write("\\t");
                continue;
            }
            char c2 = c;
            if ('\u0000' <= c2 && c2 <= '\u001f' || c == '\u007f' || '\u00ff' <= (c2 = c) && c2 <= '\uffff') {
                String string;
                String string2 = "\\u%04x";
                Object[] objectArray = new Object[]{(int)ch};
                JsonWriter jsonWriter2 = $receiver2;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                jsonWriter2.write(string);
                continue;
            }
            $receiver2.write(ch);
        }
        $receiver2.write('\"');
        return jsonWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonWriter writeObject(@NotNull JsonWriter $receiver, @NotNull Map<?, ?> obj) {
        JsonWriter jsonWriter;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        JsonWriter $receiver2 = jsonWriter = $receiver;
        if (obj.isEmpty()) {
            $receiver2.write("{}");
        } else {
            void first;
            int n;
            $receiver2.write('{');
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = true;
            JsonWriter this_$iv = $receiver2;
            try {
                JsonWriter jsonWriter2 = this_$iv;
                n = jsonWriter2.getIndentation();
                jsonWriter2.setIndentation(n + 1);
                $receiver2.line();
                Map<?, ?> map = obj;
                for (Map.Entry<?, ?> pair : map.entrySet()) {
                    if (first.element) {
                        first.element = false;
                    } else {
                        $receiver2.write(',');
                        $receiver2.line();
                    }
                    WriterKt.writeString($receiver2, String.valueOf(pair.getKey()));
                    $receiver2.space();
                    $receiver2.write(':');
                    $receiver2.space();
                    WriterKt.writeValue($receiver2, pair.getValue());
                }
            }
            finally {
                JsonWriter jsonWriter3 = this_$iv;
                n = jsonWriter3.getIndentation();
                jsonWriter3.setIndentation(n + -1);
            }
            if (!first.element) {
                $receiver2.line();
            }
            $receiver2.write('}');
            booleanRef = null;
        }
        return jsonWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonWriter writeArray(@NotNull JsonWriter $receiver, @NotNull Iterable<?> list) {
        JsonWriter jsonWriter;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        JsonWriter $receiver2 = jsonWriter = $receiver;
        List list2 = CollectionsKt.toList(list);
        if (list2.isEmpty()) {
            $receiver2.write("[]");
        } else {
            void first;
            int n;
            $receiver2.write('[');
            $receiver2.line();
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = true;
            JsonWriter this_$iv = $receiver2;
            try {
                JsonWriter jsonWriter2 = this_$iv;
                n = jsonWriter2.getIndentation();
                jsonWriter2.setIndentation(n + 1);
                for (Object item : list2) {
                    if (first.element) {
                        first.element = false;
                    } else {
                        $receiver2.write(',');
                        $receiver2.line();
                    }
                    WriterKt.writeValue($receiver2, item);
                }
            }
            finally {
                JsonWriter jsonWriter3 = this_$iv;
                n = jsonWriter3.getIndentation();
                jsonWriter3.setIndentation(n + -1);
            }
            if (!first.element) {
                $receiver2.line();
            }
            $receiver2.write(']');
            booleanRef = null;
        }
        return jsonWriter;
    }
}

