/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.net;

import com.jtransc.io.StreamKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR5\u0010\u001b\u001a&\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001d0\u001d \u001e*\u0012\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001d0\u001d\u0018\u00010\u001f0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lcom/jtransc/net/TcpClientAsync;", "", "host", "", "port", "", "handler", "Lcom/jtransc/net/TcpClientAsync$Handler;", "(Ljava/lang/String;ILcom/jtransc/net/TcpClientAsync$Handler;)V", "getHandler", "()Lcom/jtransc/net/TcpClientAsync$Handler;", "getHost", "()Ljava/lang/String;", "mustClose", "", "getMustClose", "()Z", "setMustClose", "(Z)V", "getPort", "()I", "socket", "Ljava/net/Socket;", "getSocket", "()Ljava/net/Socket;", "setSocket", "(Ljava/net/Socket;)V", "writeChunks", "", "", "kotlin.jvm.PlatformType", "", "getWriteChunks", "()Ljava/util/List;", "close", "", "write", "data", "Handler", "jtransc-utils_main"})
public final class TcpClientAsync {
    @Nullable
    private Socket socket;
    private final List<byte[]> writeChunks;
    private volatile boolean mustClose;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final Handler handler;

    @Nullable
    public final Socket getSocket() {
        return this.socket;
    }

    public final void setSocket(@Nullable Socket socket) {
        this.socket = socket;
    }

    public final List<byte[]> getWriteChunks() {
        return this.writeChunks;
    }

    public final boolean getMustClose() {
        return this.mustClose;
    }

    public final void setMustClose(boolean bl) {
        this.mustClose = bl;
    }

    public final void write(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.writeChunks.add(data);
    }

    public final void close() {
        this.mustClose = true;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final Handler getHandler() {
        return this.handler;
    }

    public TcpClientAsync(@NotNull String host, int port, @NotNull Handler handler2) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        this.host = host;
        this.port = port;
        this.handler = handler2;
        this.writeChunks = Collections.synchronizedList(new LinkedList());
        new Thread(new Runnable(){

            @Override
            public final void run() {
                Socket socket = new Socket(this.getHost(), this.getPort());
                this.setSocket(socket);
                InputStream input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                this.getHandler().onOpen();
                while (!this.getMustClose() && !socket.isClosed()) {
                    Collection collection;
                    byte[] chunk = StreamKt.readAvailableChunk(input);
                    if (chunk.length >= 1) {
                        this.getHandler().onData(chunk);
                    }
                    while (!(collection = (Collection)this.getWriteChunks()).isEmpty()) {
                        try {
                            output.write(this.getWriteChunks().remove(0));
                        }
                        catch (Throwable e$iv) {
                            e$iv.printStackTrace();
                        }
                    }
                    Thread.sleep(1L);
                }
                this.getHandler().onClose();
                try {
                    socket.close();
                }
                catch (Throwable e$iv) {
                    e$iv.printStackTrace();
                }
            }
        }).start();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lcom/jtransc/net/TcpClientAsync$Handler;", "", "onClose", "", "onData", "data", "", "onOpen", "jtransc-utils_main"})
    public static interface Handler {
        public void onOpen();

        public void onData(@NotNull byte[] var1);

        public void onClose();
    }
}

