/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.serialization.xml;

import com.jtransc.error.ErrorsKt;
import com.jtransc.serialization.xml.StrReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"readStringLit", "", "Lcom/jtransc/serialization/xml/StrReader;", "reportErrors", "", "jtransc-utils_main"})
public final class StrReaderKt {
    @NotNull
    public static final String readStringLit(@NotNull StrReader $receiver, boolean reportErrors) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder out = new StringBuilder();
        char quotec = $receiver.read();
        switch (quotec) {
            case '\"': 
            case '\'': {
                break;
            }
            default: {
                Void void_ = ErrorsKt.invalidOp$default("Invalid string literal", null, 2, null);
                throw null;
            }
        }
        boolean closed = false;
        while ($receiver.getHasMore()) {
            char c = $receiver.read();
            if (c == '\\') {
                char c2;
                char cc = $receiver.read();
                StringBuilder stringBuilder = out;
                switch (cc) {
                    case '\\': {
                        c2 = '\\';
                        break;
                    }
                    case '/': {
                        c2 = '/';
                        break;
                    }
                    case '\'': {
                        c2 = '\'';
                        break;
                    }
                    case '\"': {
                        c2 = '\"';
                        break;
                    }
                    case 'b': {
                        c2 = '\b';
                        break;
                    }
                    case 'f': {
                        c2 = '\f';
                        break;
                    }
                    case 'n': {
                        c2 = '\n';
                        break;
                    }
                    case 'r': {
                        c2 = '\r';
                        break;
                    }
                    case 't': {
                        c2 = '\t';
                        break;
                    }
                    case 'u': {
                        String string = $receiver.read(4);
                        int n = 16;
                        StringBuilder stringBuilder2 = stringBuilder;
                        int n2 = Integer.parseInt(string, CharsKt.checkRadix((int)n));
                        stringBuilder = stringBuilder2;
                        c2 = (char)n2;
                        break;
                    }
                    default: {
                        Void void_ = ErrorsKt.invalidOp$default("Invalid char '" + cc + "'", null, 2, null);
                        throw null;
                    }
                }
                stringBuilder.append(c2);
                continue;
            }
            if (c == quotec) {
                closed = true;
                break;
            }
            out.append(c);
        }
        if (!closed && reportErrors) {
            throw (Throwable)new RuntimeException("String literal not closed! '" + $receiver.getStr() + "'");
        }
        String string = out.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String readStringLit$default(StrReader strReader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return StrReaderKt.readStringLit(strReader, bl);
    }
}

