/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.text;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0001\u001a\f\u0010\u0004\u001a\u00020\u0001*\u0004\u0018\u00010\u0001\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\b\u001a\u00020\u0001*\u0004\u0018\u00010\u0001\u00a8\u0006\t"}, d2={"escape", "", "isQuoted", "", "quote", "uescape", "unescape", "unquote", "uquote", "jtransc-utils_main"})
public final class EscapeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String escape(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder out = new StringBuilder();
        IntRange intRange = RangesKt.until((int)0, (int)$receiver.length());
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void n3;
                char c;
                char c2;
                if ((c2 = (c = $receiver.charAt((int)n3))) == '\\') {
                    out.append("\\\\");
                } else if (c2 == '\"') {
                    out.append("\\\"");
                } else if (c2 == '\n') {
                    out.append("\\n");
                } else if (c2 == '\r') {
                    out.append("\\r");
                } else if (c2 == '\t') {
                    out.append("\\t");
                } else {
                    char c3 = c2;
                    if ('\u0000' <= c3 && c3 <= '\u001f') {
                        String string;
                        String string2 = "%02x";
                        Object[] objectArray = new Object[]{(int)c};
                        StringBuilder stringBuilder = new StringBuilder().append("\\x");
                        StringBuilder stringBuilder2 = out;
                        Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                        stringBuilder2.append(stringBuilder.append(string).toString());
                    } else {
                        out.append(c);
                    }
                }
                if (n3 == n2) break;
                ++n3;
            }
        }
        String string = out.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String uescape(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder out = new StringBuilder();
        IntRange intRange = RangesKt.until((int)0, (int)$receiver.length());
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void n3;
                char c;
                char c2;
                if ((c2 = (c = $receiver.charAt((int)n3))) == (char)0) {
                    out.append("\\0");
                } else if (c2 == '\\') {
                    out.append("\\\\");
                } else if (c2 == '\"') {
                    out.append("\\\"");
                } else if (c2 == '\n') {
                    out.append("\\n");
                } else if (c2 == '\r') {
                    out.append("\\r");
                } else if (c2 == '\t') {
                    out.append("\\t");
                } else {
                    char c3 = c2;
                    if ('a' <= c3 && c3 <= 'z' || 'A' <= (c3 = c2) && c3 <= 'Z' || '0' <= (c3 = c2) && c3 <= '9' || c2 == '_' || c2 == '.' || c2 == ',' || c2 == ';' || c2 == ':' || c2 == '<' || c2 == '>' || c2 == '{' || c2 == '}' || c2 == '[' || c2 == ']' || c2 == '/' || c2 == ' ' || c2 == '=' || c2 == '!' || c2 == '%' || c2 == '&') {
                        out.append(c);
                    } else {
                        String string;
                        String string2 = "%04x";
                        Object[] objectArray = new Object[]{(int)c};
                        StringBuilder stringBuilder = new StringBuilder().append("\\u");
                        StringBuilder stringBuilder2 = out;
                        Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                        stringBuilder2.append(stringBuilder.append(string).toString());
                    }
                }
                if (n3 == n2) break;
                ++n3;
            }
        }
        String string = out.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
        return string;
    }

    @NotNull
    public static final String unescape(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder out = new StringBuilder();
        int n = 0;
        while (n < $receiver.length()) {
            char c = $receiver.charAt(n++);
            block0 : switch (c) {
                case '\\': {
                    char c2 = $receiver.charAt(n++);
                    switch (c2) {
                        case '\\': {
                            out.append('\\');
                            break block0;
                        }
                        case '\"': {
                            out.append('\"');
                            break block0;
                        }
                        case 'n': {
                            out.append('\n');
                            break block0;
                        }
                        case 'r': {
                            out.append('\r');
                            break block0;
                        }
                        case 't': {
                            out.append('\t');
                            break block0;
                        }
                        case 'u': {
                            String chars;
                            String string = $receiver;
                            int n2 = n + 4;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            n += 4;
                            out.append((char)Integer.parseInt(chars, 16));
                            break block0;
                        }
                    }
                    out.append("\\" + c2);
                    break;
                }
                default: {
                    out.append(c);
                }
            }
        }
        String string = out.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
        return string;
    }

    @NotNull
    public static final String uquote(@Nullable String $receiver) {
        return $receiver != null ? "\"" + EscapeKt.uescape($receiver) + "\"" : "null";
    }

    @NotNull
    public static final String quote(@Nullable String $receiver) {
        return $receiver != null ? "\"" + EscapeKt.escape($receiver) + "\"" : "null";
    }

    public static final boolean isQuoted(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.startsWith$default((CharSequence)$receiver, (char)'\"', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$receiver, (char)'\"', (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String unquote(@NotNull String $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (EscapeKt.isQuoted($receiver)) {
            String string2 = $receiver;
            int n = 1;
            int n2 = $receiver.length() - 1;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = EscapeKt.unescape(string3);
        } else {
            string = String.valueOf($receiver);
        }
        return string;
    }
}

