/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.text;

import com.jtransc.error.ErrorsKt;
import com.jtransc.error.InvalidOperationException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0005J?\u0010 \u001a\b\u0012\u0004\u0012\u0002H\"0!\"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020\u00052#\u0010$\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0006\u0012\u0004\u0018\u0001H\"0%J\u0006\u0010)\u001a\u00020\u001eJ\u0006\u0010*\u001a\u00020\u0000J\b\u0010+\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000f\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/jtransc/text/StrReader;", "", "str", "", "offset", "", "(Ljava/lang/String;I)V", "eof", "", "getEof", "()Z", "hasMore", "getHasMore", "length", "getLength", "()I", "getOffset", "setOffset", "(I)V", "getStr", "()Ljava/lang/String;", "clone", "expect", "expected", "matchEReg", "v", "Lkotlin/text/Regex;", "peek", "count", "peekch", "", "read", "readList", "", "T", "min", "readElement", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "s", "readch", "skipSpaces", "toString", "jtransc-utils_main"})
public final class StrReader {
    @NotNull
    private final String str;
    private int offset;

    public final int getLength() {
        return this.str.length();
    }

    public final boolean getEof() {
        return this.offset >= this.getLength();
    }

    public final boolean getHasMore() {
        return !this.getEof();
    }

    public final char readch() {
        int n = this.offset;
        this.offset = n + 1;
        return this.str.charAt(n);
    }

    public final int read() {
        return !this.getEof() ? (int)this.readch() : -1;
    }

    @NotNull
    public final String peek(int count) {
        if (this.offset >= this.getLength()) {
            return "";
        }
        String string = this.str;
        int n = this.offset;
        int n2 = Math.min(this.getLength(), this.offset + count);
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    public final char peekch() {
        return this.getHasMore() ? this.str.charAt(this.offset) : (char)0;
    }

    @NotNull
    public final String read(int count) {
        String out = this.peek(count);
        this.offset += count;
        return out;
    }

    @NotNull
    public final StrReader skipSpaces() {
        CharSequence charSequence;
        while (this.getHasMore() && ((charSequence = (CharSequence)this.peek(1)) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.read();
        }
        return this;
    }

    @NotNull
    public final String expect(@NotNull String expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        String result2 = this.read(expected.length());
        if (Intrinsics.areEqual((Object)result2, (Object)expected) ^ true) {
            throw (Throwable)new InvalidOperationException("Expecting '" + expected + "' but found '" + result2 + "' in '" + this.str + "'", null, 2, null);
        }
        return result2;
    }

    @Nullable
    public final String matchEReg(@NotNull Regex v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        String string = this.str;
        int n = this.offset;
        Regex regex = v;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = string3;
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string4, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result2 = matchResult;
        MatchGroup matchGroup = result2.getGroups().get(0);
        if (matchGroup == null) {
            Intrinsics.throwNpe();
        }
        String m = matchGroup.getValue();
        this.offset += m.length();
        return m;
    }

    @NotNull
    public String toString() {
        return "StrReader('" + this.str + "')";
    }

    @NotNull
    public final <T> List<T> readList(int min, @NotNull Function1<? super StrReader, ? extends T> readElement) {
        Intrinsics.checkParameterIsNotNull(readElement, (String)"readElement");
        ArrayList<Object> out = new ArrayList<Object>();
        while (this.getHasMore()) {
            Object object = readElement.invoke((Object)this);
            if (object == null) {
                break;
            }
            out.add(object);
        }
        if (out.size() < min) {
            Void void_ = ErrorsKt.invalidOp$default("Expected a list of at least " + min + " elements and had " + out.size(), null, 2, null);
            throw null;
        }
        return out;
    }

    @NotNull
    public final StrReader clone() {
        return new StrReader(this.str, this.offset);
    }

    @NotNull
    public final String getStr() {
        return this.str;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public StrReader(@NotNull String str, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        this.str = str;
        this.offset = offset;
    }

    public /* synthetic */ StrReader(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(string, n);
    }
}

