/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.util;

import com.jtransc.util.BinarySerializer;
import com.jtransc.util.PersistentBinaryCache;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002\u00a2\u0006\u0002\u0010\rJ6\u0010\u000e\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jtransc/util/PersistentCache;", "V", "", "()V", "pbc", "Lcom/jtransc/util/PersistentBinaryCache;", "getPbc", "()Lcom/jtransc/util/PersistentBinaryCache;", "contains", "", "key", "", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "getCalc", "calculate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "jtransc-utils_main"})
public final class PersistentCache<V> {
    @NotNull
    private final PersistentBinaryCache pbc = PersistentBinaryCache.INSTANCE;

    @NotNull
    public final PersistentBinaryCache getPbc() {
        return this.pbc;
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.pbc.contains(key);
    }

    public final void set(@NotNull String key, V value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.pbc.set(key, BinarySerializer.INSTANCE.serialize(value));
    }

    @Nullable
    public final V get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        byte[] bvalue = this.pbc.get(key);
        return bvalue != null ? (V)BinarySerializer.INSTANCE.deserialize(bvalue) : null;
    }

    public final V getCalc(@NotNull String key, @NotNull Function1<? super String, ? extends V> calculate) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(calculate, (String)"calculate");
        if (this.contains(key) ^ true) {
            Object obj = calculate.invoke((Object)key);
            this.set(key, obj);
            return (V)obj;
        }
        V v = this.get(key);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return v;
    }

    public PersistentCache() {
        String string = "PersistentCache: " + this.pbc.getTempFolder();
        System.out.println((Object)string);
    }
}

