/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.vfs;

import com.jtransc.error.InvalidOperationException;
import com.jtransc.vfs.ProxySyncVfs;
import com.jtransc.vfs.SyncVfs;
import com.jtransc.vfs.SyncVfsFile;
import com.jtransc.vfs.SyncVfsStat;
import com.jtransc.vfs.SyncvfsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/jtransc/vfs/AccessSyncVfs;", "Lcom/jtransc/vfs/ProxySyncVfs;", "parent", "Lcom/jtransc/vfs/SyncVfs;", "path", "", "(Lcom/jtransc/vfs/SyncVfs;Ljava/lang/String;)V", "getParent", "()Lcom/jtransc/vfs/SyncVfs;", "getPath", "()Ljava/lang/String;", "toString", "transform", "Lcom/jtransc/vfs/SyncVfsFile;", "transformStat", "Lcom/jtransc/vfs/SyncVfsStat;", "stat", "jtransc-utils_main"})
final class AccessSyncVfs
extends ProxySyncVfs {
    @NotNull
    private final SyncVfs parent;
    @NotNull
    private final String path;

    @Override
    @NotNull
    protected SyncVfsFile transform(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new SyncVfsFile(this.parent, SyncvfsKt.jailCombinePath(this.path, path));
    }

    @Override
    @NotNull
    protected SyncVfsStat transformStat(@NotNull SyncVfsStat stat2) {
        Intrinsics.checkParameterIsNotNull((Object)stat2, (String)"stat");
        String statFilePath = "/" + StringsKt.trimStart((String)stat2.getFile().getPath(), (char[])new char[]{'/'});
        String thisPath = "/" + StringsKt.trimStart((String)this.path, (char[])new char[]{'/'});
        if (!StringsKt.startsWith$default((String)statFilePath, (String)thisPath, (boolean)false, (int)2, null)) {
            throw (Throwable)new InvalidOperationException("Assertion failed " + statFilePath + " must start with " + thisPath, null, 2, null);
        }
        return new SyncVfsStat(new SyncVfsFile(this, "/" + StringsKt.removePrefix((String)statFilePath, (CharSequence)thisPath)), stat2.getSize(), stat2.getMtime(), stat2.isDirectory(), stat2.isSymlink(), true, stat2.getMode());
    }

    @NotNull
    public String toString() {
        return "AccessSyncVfs(" + this.parent + ", " + this.path + ")";
    }

    @NotNull
    public final SyncVfs getParent() {
        return this.parent;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public AccessSyncVfs(@NotNull SyncVfs parent, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.parent = parent;
        this.path = path;
    }
}

