/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.vfs;

import com.jtransc.vfs.FileMode;
import com.jtransc.vfs.SyncVfs;
import com.jtransc.vfs.SyncVfsStat;
import com.jtransc.vfs.SyncvfsKt;
import com.jtransc.vfs.node.FileNode;
import com.jtransc.vfs.node.FileNodeIO;
import com.jtransc.vfs.node.FileNodeTree;
import com.jtransc.vfs.node.FileNodeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/jtransc/vfs/BaseTreeVfs;", "Lcom/jtransc/vfs/SyncVfs;", "tree", "Lcom/jtransc/vfs/node/FileNodeTree;", "(Lcom/jtransc/vfs/node/FileNodeTree;)V", "_root", "Lcom/jtransc/vfs/node/FileNode;", "get_root", "()Lcom/jtransc/vfs/node/FileNode;", "absolutePath", "", "getAbsolutePath", "()Ljava/lang/String;", "getTree", "()Lcom/jtransc/vfs/node/FileNodeTree;", "exists", "", "path", "listdir", "", "Lcom/jtransc/vfs/SyncVfsStat;", "mkdir", "", "read", "", "remove", "rmdir", "setMtime", "time", "Ljava/util/Date;", "stat", "write", "data", "jtransc-utils_main"})
public class BaseTreeVfs
extends SyncVfs {
    @NotNull
    private final FileNode _root;
    @NotNull
    private final FileNodeTree tree;

    @NotNull
    protected final FileNode get_root() {
        return this._root;
    }

    @Override
    @NotNull
    public String getAbsolutePath() {
        return "";
    }

    @Override
    @NotNull
    public byte[] read(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileNodeIO fileNodeIO = FileNode.access$default(this._root, path, false, 2, null).getIo();
        Object object = fileNodeIO != null ? fileNodeIO.read() : null;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return object;
    }

    @Override
    public void write(@NotNull String path, @NotNull byte[] data) {
        Object writtenData;
        Object writtenTime;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        FileNode item = this._root.access(path, true);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = data;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = new Date();
        item.setType(FileNodeType.FILE);
        item.setIo(new FileNodeIO(writtenTime, writtenData){
            final /* synthetic */ Ref.ObjectRef $writtenTime;
            final /* synthetic */ Ref.ObjectRef $writtenData;

            @NotNull
            public Date mtime() {
                return (Date)this.$writtenTime.element;
            }

            @NotNull
            public byte[] read() {
                return (byte[])this.$writtenData.element;
            }

            public void write(@NotNull byte[] data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$writtenTime.element = new Date();
                this.$writtenData.element = data;
            }

            public long size() {
                return ((byte[])this.$writtenData.element).length;
            }

            @NotNull
            public FileMode mode() {
                return FileMode.Companion.getFULL_ACCESS();
            }
            {
                this.$writtenTime = $captured_local_variable$0;
                this.$writtenData = $captured_local_variable$1;
            }
        });
        writtenTime = null;
        writtenData = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<SyncVfsStat> listdir(@NotNull String path) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Iterable iterable = $receiver$iv = (Iterable)FileNode.access$default(this._root, path, false, 2, null);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            FileNode fileNode = (FileNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            SyncVfsStat syncVfsStat = SyncvfsKt.toSyncStat((FileNode)it, (SyncVfs)this, path + "/" + it.getName());
            collection.add(syncVfsStat);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void mkdir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this._root.access(path, true);
    }

    @Override
    public void rmdir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            FileNode node = this._root.access(path, false);
            node.remove();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            FileNode.access$default(this._root, path, false, 2, null);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void remove(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileNode.access$default(this._root, path, false, 2, null).remove();
    }

    @Override
    @NotNull
    public SyncVfsStat stat(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return SyncvfsKt.toSyncStat(FileNode.access$default(this._root, path, false, 2, null), (SyncVfs)this, path);
    }

    @Override
    public void setMtime(@NotNull String path, @NotNull Date time) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
    }

    @NotNull
    public final FileNodeTree getTree() {
        return this.tree;
    }

    public BaseTreeVfs(@NotNull FileNodeTree tree) {
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        this.tree = tree;
        this._root = this.tree.getRoot();
    }
}

