/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.vfs;

import com.jtransc.error.InvalidArgumentException;
import com.jtransc.vfs.ExecOptions;
import com.jtransc.vfs.ProcessResult;
import com.jtransc.vfs.SyncVfs;
import com.jtransc.vfs.SyncVfsFile;
import com.jtransc.vfs.SyncVfsStat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0007H\u0016JF\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J)\u0010%\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u001b0'2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010/\u001a\u00020\u0007H\u0016J\u0018\u00100\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u00101\u001a\u00020$H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u00062"}, d2={"Lcom/jtransc/vfs/MergedSyncVfs;", "Lcom/jtransc/vfs/SyncVfs;", "nodes", "", "Lcom/jtransc/vfs/SyncVfsFile;", "(Ljava/util/List;)V", "absolutePath", "", "getAbsolutePath", "()Ljava/lang/String;", "getNodes", "()Ljava/util/List;", "nodesSorted", "getNodesSorted", "exec", "Lcom/jtransc/vfs/ProcessResult;", "path", "cmd", "args", "options", "Lcom/jtransc/vfs/ExecOptions;", "listdir", "", "Lcom/jtransc/vfs/SyncVfsStat;", "mkdir", "", "op", "T", "act", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "node", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "read", "", "readSpecial", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "remove", "rmdir", "setMtime", "time", "Ljava/util/Date;", "stat", "toString", "write", "data", "jtransc-utils_main"})
final class MergedSyncVfs
extends SyncVfs {
    @NotNull
    private final String absolutePath = "#merged#";
    @NotNull
    private final List<SyncVfsFile> nodesSorted;
    @NotNull
    private final List<SyncVfsFile> nodes;

    @Override
    @NotNull
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @NotNull
    public final List<SyncVfsFile> getNodesSorted() {
        return this.nodesSorted;
    }

    private final <T> T op(String path, String act, Function1<? super SyncVfsFile, ? extends T> action) {
        Throwable lastError = null;
        for (SyncVfsFile node : this.nodesSorted) {
            try {
                return (T)action.invoke((Object)node);
            }
            catch (Throwable t) {
                lastError = t;
            }
        }
        throw (Throwable)new RuntimeException("Can't " + act + " file '" + path + "' : " + lastError);
    }

    @Override
    @NotNull
    public byte[] read(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return (byte[])this.op(path, "read", (Function1)new Function1<SyncVfsFile, byte[]>(path){
            final /* synthetic */ String $path;

            @NotNull
            public final byte[] invoke(@NotNull SyncVfsFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.get(this.$path).read();
            }
            {
                this.$path = string;
                super(1);
            }
        });
    }

    @Override
    public void write(@NotNull String path, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.op(path, "write", (Function1)new Function1<SyncVfsFile, Unit>(path, data){
            final /* synthetic */ String $path;
            final /* synthetic */ byte[] $data;

            public final void invoke(@NotNull SyncVfsFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.get(this.$path).write(this.$data);
            }
            {
                this.$path = string;
                this.$data = byArray;
                super(1);
            }
        });
    }

    @Override
    public <T> T readSpecial(@NotNull Class<T> clazz, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.op(path, "readSpecial", (Function1)new Function1<SyncVfsFile, T>(path, clazz){
            final /* synthetic */ String $path;
            final /* synthetic */ Class $clazz;

            public final T invoke(@NotNull SyncVfsFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.get(this.$path).readSpecial(this.$clazz);
            }
            {
                this.$path = string;
                this.$clazz = clazz;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<SyncVfsStat> listdir(@NotNull String path) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Iterable iterable = $receiver$iv = (Iterable)this.nodesSorted;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SyncVfsFile it = (SyncVfsFile)element$iv$iv;
            Iterable<SyncVfsStat> list$iv$iv = it.listdir();
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void mkdir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.op(path, "mkdir", (Function1)new Function1<SyncVfsFile, Unit>(path){
            final /* synthetic */ String $path;

            public final void invoke(@NotNull SyncVfsFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.get(this.$path).mkdir();
            }
            {
                this.$path = string;
                super(1);
            }
        });
    }

    @Override
    public void rmdir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.op(path, "rmdir", (Function1)new Function1<SyncVfsFile, Unit>(path){
            final /* synthetic */ String $path;

            public final void invoke(@NotNull SyncVfsFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.get(this.$path).rmdir();
            }
            {
                this.$path = string;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public ProcessResult exec(@NotNull String path, @NotNull String cmd, @NotNull List<String> args, @NotNull ExecOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return (ProcessResult)this.op(path, "exec", (Function1)new Function1<SyncVfsFile, ProcessResult>(path, cmd, args, options){
            final /* synthetic */ String $path;
            final /* synthetic */ String $cmd;
            final /* synthetic */ List $args;
            final /* synthetic */ ExecOptions $options;

            @NotNull
            public final ProcessResult invoke(@NotNull SyncVfsFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.get(this.$path).exec(this.$cmd, (List<String>)this.$args, this.$options);
            }
            {
                this.$path = string;
                this.$cmd = string2;
                this.$args = list;
                this.$options = execOptions;
                super(1);
            }
        });
    }

    @Override
    public void remove(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.op(path, "remove", (Function1)new Function1<SyncVfsFile, Unit>(path){
            final /* synthetic */ String $path;

            public final void invoke(@NotNull SyncVfsFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.get(this.$path).remove();
            }
            {
                this.$path = string;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public SyncVfsStat stat(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        SyncVfsStat lastStat = null;
        for (SyncVfsFile node : this.nodesSorted) {
            SyncVfsStat stat2;
            lastStat = stat2 = node.get(path).stat();
            if (!stat2.getExists()) continue;
            break;
        }
        SyncVfsStat syncVfsStat = lastStat;
        if (syncVfsStat == null) {
            Intrinsics.throwNpe();
        }
        return syncVfsStat;
    }

    @Override
    public void setMtime(@NotNull String path, @NotNull Date time) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        this.op(path, "setMtime", (Function1)new Function1<SyncVfsFile, Unit>(path, time){
            final /* synthetic */ String $path;
            final /* synthetic */ Date $time;

            public final void invoke(@NotNull SyncVfsFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.get(this.$path).setMtime(this.$time);
            }
            {
                this.$path = string;
                this.$time = date;
                super(1);
            }
        });
    }

    @NotNull
    public String toString() {
        return "MergedSyncVfs(" + CollectionsKt.joinToString$default((Iterable)this.nodes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    @NotNull
    public final List<SyncVfsFile> getNodes() {
        return this.nodes;
    }

    public MergedSyncVfs(@NotNull List<SyncVfsFile> nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        this.nodes = nodes;
        if (this.nodes.isEmpty()) {
            throw (Throwable)new InvalidArgumentException("Nodes can't be empty");
        }
        this.absolutePath = "#merged#";
        this.nodesSorted = this.nodes;
    }
}

