/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.vfs;

import com.jtransc.error.ErrorsKt;
import com.jtransc.io.ProcessResult2;
import com.jtransc.io.ProcessUtils;
import com.jtransc.vfs.ExecOptions;
import com.jtransc.vfs.FileMode;
import com.jtransc.vfs.IoKt;
import com.jtransc.vfs.ProcessResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0004J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0017J\u0019\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\"\u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jtransc/vfs/RawIo;", "", "()V", "userDir", "", "kotlin.jvm.PlatformType", "chdir", "", "path", "chmod", "", "mode", "Lcom/jtransc/vfs/FileMode;", "cwd", "execOrPassthruSync", "Lcom/jtransc/vfs/ProcessResult;", "cmd", "args", "", "options", "Lcom/jtransc/vfs/ExecOptions;", "fileExists", "fileRead", "", "fileRemove", "fileStat", "Ljava/io/File;", "fileWrite", "data", "listdir", "", "(Ljava/lang/String;)[Ljava/io/File;", "mkdir", "rmdir", "script", "setMtime", "time", "Ljava/util/Date;", "symlink", "link", "target", "jtransc-utils_main"})
public final class RawIo {
    private static String userDir;
    public static final RawIo INSTANCE;

    @NotNull
    public final byte[] fileRead(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return IoKt.readFastBytes(new File(path));
    }

    public final void fileWrite(@NotNull String path, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        FilesKt.writeBytes((File)new File(path), (byte[])data);
    }

    @NotNull
    public final File[] listdir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = new File(path);
        if (!file.exists()) {
            throw (Throwable)new FileNotFoundException("Can't find " + path);
        }
        File[] fileArray = file.listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"file.listFiles()");
        return fileArray;
    }

    public final boolean fileExists(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new File(path).exists();
    }

    public final void rmdir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        new File(path).delete();
    }

    public final void fileRemove(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        new File(path).delete();
    }

    @NotNull
    public final File fileStat(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new File(path);
    }

    public final void setMtime(@NotNull String path, @NotNull Date time) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        new File(path).setLastModified(time.getTime());
    }

    @NotNull
    public final String cwd() {
        String string = userDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"userDir");
        return string;
    }

    @NotNull
    public final String script() {
        String string = userDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"userDir");
        return string;
    }

    public final void chdir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        userDir = new File(path).getCanonicalPath();
    }

    @NotNull
    public final ProcessResult execOrPassthruSync(@NotNull String path, @NotNull String cmd, @NotNull List<String> args, @NotNull ExecOptions options) {
        ProcessResult processResult;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        ProcessResult2 result2 = ProcessUtils.INSTANCE.run(new File(path), cmd, args, options);
        String string = result2.getOut();
        Charset charset = null;
        boolean bl = true;
        Object var9_9 = null;
        ProcessResult processResult2 = processResult;
        ProcessResult processResult3 = processResult;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        string = result2.getErr();
        charset = null;
        bl = true;
        var9_9 = null;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray3 = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        processResult2(byArray2, byArray4, result2.getExitValue());
        return processResult3;
    }

    public final void mkdir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        new File(path).mkdir();
    }

    public final boolean chmod(@NotNull String path, @NotNull FileMode mode) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        Void void_ = ErrorsKt.noImpl("Not implemented chmod");
        throw null;
    }

    public final void symlink(@NotNull String link, @NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Void void_ = ErrorsKt.noImpl("Not implemented symlink");
        throw null;
    }

    private RawIo() {
        INSTANCE = this;
        userDir = System.getProperty("user.dir");
    }

    static {
        new RawIo();
    }
}

