/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.vfs;

import com.jtransc.env.OS;
import com.jtransc.error.ErrorsKt;
import com.jtransc.log.log;
import com.jtransc.text.ToString;
import com.jtransc.vfs.AccessSyncVfs;
import com.jtransc.vfs.ExecOptions;
import com.jtransc.vfs.FileMode;
import com.jtransc.vfs.IoKt;
import com.jtransc.vfs.ProcessResult;
import com.jtransc.vfs.SyncVfs;
import com.jtransc.vfs.SyncVfsFile;
import com.jtransc.vfs.SyncVfsStat;
import com.jtransc.vfs.SyncvfsKt;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0011\u0010'\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0000JR\u0010*\u001a\u00020$2\u0006\u0010)\u001a\u00020\u000028\b\u0002\u0010+\u001a2\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b-\u0012\b\b\u0010\u0012\u0004\b\b(.\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b-\u0012\b\b\u0010\u0012\u0004\b\b(/\u0012\u0004\u0012\u00020\b0,2\b\b\u0002\u00100\u001a\u00020\bJ\u0006\u00101\u001a\u00020$J\u0006\u00102\u001a\u00020\u0000J\u0006\u00103\u001a\u00020\u0000J=\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00052\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000508\"\u00020\u00052\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050:\u00a2\u0006\u0002\u0010;J$\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00052\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050<2\u0006\u0010=\u001a\u00020>J2\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00052\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050<2\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050:J\u001e\u00104\u001a\u0002052\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050<2\b\b\u0002\u0010=\u001a\u00020>J)\u0010@\u001a\u00020A2!\u0010+\u001a\u001d\u0012\u0013\u0012\u00110A\u00a2\u0006\f\b-\u0012\b\b\u0010\u0012\u0004\b\b(C\u0012\u0004\u0012\u00020\b0BJ\u0011\u0010D\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010E\u001a\u00020\u0000J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\f\u0010G\u001a\b\u0012\u0004\u0012\u00020A0HJ\f\u0010I\u001a\b\u0012\u0004\u0012\u00020A0HJ/\u0010I\u001a\b\u0012\u0004\u0012\u00020A0H2!\u0010+\u001a\u001d\u0012\u0013\u0012\u00110A\u00a2\u0006\f\b-\u0012\b\b\u0010\u0012\u0004\b\b(C\u0012\u0004\u0012\u00020\b0BJ\u0006\u0010J\u001a\u00020$Jd\u0010K\u001a\u0002052\u0006\u00106\u001a\u00020\u00052\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000508\"\u00020\u00052%\b\u0002\u0010+\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b-\u0012\b\b\u0010\u0012\u0004\b\b(L\u0012\u0004\u0012\u00020\b\u0018\u00010B2\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050:\u00a2\u0006\u0002\u0010MJY\u0010K\u001a\u0002052\u0006\u00106\u001a\u00020\u00052\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050<2%\b\u0002\u0010+\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b-\u0012\b\b\u0010\u0012\u0004\b\b(L\u0012\u0004\u0012\u00020\b\u0018\u00010B2\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050:J\u0006\u0010N\u001a\u00020OJ\u0006\u0010P\u001a\u00020OJ\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00050<2\b\b\u0002\u0010R\u001a\u00020SJ\b\u0010T\u001a\u0004\u0018\u00010OJ\u001a\u0010U\u001a\u0002HV\"\n\b\u0000\u0010V\u0018\u0001*\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010WJ\u001f\u0010U\u001a\u0002HV\"\u0004\b\u0000\u0010V2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HV0Y\u00a2\u0006\u0002\u0010ZJ\u0010\u0010[\u001a\u00020\u00052\b\b\u0002\u0010R\u001a\u00020SJ\u0006\u0010\\\u001a\u00020$J\u0006\u0010]\u001a\u00020$J\u0006\u0010^\u001a\u00020$J\u0006\u0010_\u001a\u00020$J\u0006\u0010`\u001a\u00020$J\u0019\u0010a\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010b\u001a\u00020cH\u0086\u0002J\u0019\u0010a\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010b\u001a\u00020\u0000H\u0086\u0002J\u0019\u0010a\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010b\u001a\u00020OH\u0086\u0002J\u0019\u0010a\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010b\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010d\u001a\u00020$2\u0006\u0010e\u001a\u00020\rJ\u0006\u0010C\u001a\u00020AJ\u000e\u0010f\u001a\u00020$2\u0006\u0010g\u001a\u00020\u0005J\u0006\u0010h\u001a\u00020\u0005J\b\u0010i\u001a\u00020\u0005H\u0016J\u000e\u0010j\u001a\u00020$2\u0006\u0010k\u001a\u00020OJ\u0018\u0010j\u001a\u00020\u00002\u0006\u0010k\u001a\u00020\u00052\b\b\u0002\u0010R\u001a\u00020SJ\u0018\u0010l\u001a\u00020\u00002\u0006\u0010k\u001a\u00020\u00052\b\b\u0002\u0010R\u001a\u00020SR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006m"}, d2={"Lcom/jtransc/vfs/SyncVfsFile;", "", "vfs", "Lcom/jtransc/vfs/SyncVfs;", "path", "", "(Lcom/jtransc/vfs/SyncVfs;Ljava/lang/String;)V", "exists", "", "getExists", "()Z", "isDirectory", "mtime", "Ljava/util/Date;", "getMtime", "()Ljava/util/Date;", "name", "getName", "()Ljava/lang/String;", "getPath", "realfile", "Ljava/io/File;", "getRealfile", "()Ljava/io/File;", "realpath", "getRealpath", "realpathOS", "getRealpathOS", "size", "", "getSize", "()J", "getVfs$jtransc_utils_main", "()Lcom/jtransc/vfs/SyncVfs;", "access", "chmod", "", "mode", "Lcom/jtransc/vfs/FileMode;", "contains", "copyTo", "that", "copyTreeTo", "filter", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "from", "to", "doLog", "dumpTree", "ensureParentDir", "ensuredir", "exec", "Lcom/jtransc/vfs/ProcessResult;", "cmd", "args", "", "env", "", "(Ljava/lang/String;[Ljava/lang/String;Ljava/util/Map;)Lcom/jtransc/vfs/ProcessResult;", "", "options", "Lcom/jtransc/vfs/ExecOptions;", "cmdAndArgs", "firstRecursive", "Lcom/jtransc/vfs/SyncVfsStat;", "Lkotlin/Function1;", "stat", "get", "jail", "jailAccess", "listdir", "", "listdirRecursive", "mkdir", "passthru", "line", "(Ljava/lang/String;[Ljava/lang/String;Lkotlin/jvm/functions/Function1;Ljava/util/Map;)Lcom/jtransc/vfs/ProcessResult;", "read", "", "readBytes", "readLines", "encoding", "Ljava/nio/charset/Charset;", "readOrNull", "readSpecial", "T", "()Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "readString", "remove", "removeIfExists", "rmdir", "rmdirRecursively", "rmdirRecursivelyIfExists", "set", "content", "Lcom/jtransc/text/ToString;", "setMtime", "time", "symlinkTo", "target", "toDumpString", "toString", "write", "data", "writeString", "jtransc-utils_main"})
public final class SyncVfsFile {
    @NotNull
    private final SyncVfs vfs;
    @NotNull
    private final String path;

    public final long getSize() {
        return this.stat().getSize();
    }

    @NotNull
    public final Date getMtime() {
        return this.stat().getMtime();
    }

    public final void setMtime(@NotNull Date time) {
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        this.vfs.setMtime(this.path, time);
    }

    @NotNull
    public final SyncVfsStat stat() {
        return this.vfs.stat(this.path);
    }

    public final void chmod(@NotNull FileMode mode) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        this.vfs.chmod(this.path, mode);
    }

    public final void symlinkTo(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.vfs.symlink(this.path, target);
    }

    @NotNull
    public final byte[] read() {
        return this.vfs.read(this.path);
    }

    @NotNull
    public final byte[] readBytes() {
        return this.read();
    }

    @Nullable
    public final byte[] readOrNull() {
        return this.getExists() ? this.read() : null;
    }

    private final <T> T readSpecial() {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.readSpecial(Object.class);
    }

    public final <T> T readSpecial(@NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return this.vfs.readSpecial(clazz, this.path);
    }

    public final void write(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.vfs.write(this.path, data);
    }

    @NotNull
    public final String readString(@NotNull Charset encoding) {
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        return IoKt.toString(encoding, this.vfs.read(this.path));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String readString$default(SyncVfsFile syncVfsFile, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return syncVfsFile.readString(charset);
    }

    @NotNull
    public final List<String> readLines(@NotNull Charset encoding) {
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        return StringsKt.lines((CharSequence)this.readString(encoding));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List readLines$default(SyncVfsFile syncVfsFile, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return syncVfsFile.readLines(charset);
    }

    public final boolean getExists() {
        return this.vfs.exists(this.path);
    }

    public final boolean isDirectory() {
        return this.stat().isDirectory();
    }

    public final void remove() {
        this.vfs.remove(this.path);
    }

    public final void removeIfExists() {
        block0: {
            if (!this.getExists()) break block0;
            this.remove();
        }
    }

    @NotNull
    public final ProcessResult exec(@NotNull List<String> cmdAndArgs, @NotNull ExecOptions options) {
        Intrinsics.checkParameterIsNotNull(cmdAndArgs, (String)"cmdAndArgs");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return this.vfs.exec(this.path, (String)CollectionsKt.first(cmdAndArgs), CollectionsKt.drop((Iterable)cmdAndArgs, (int)1), options);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ProcessResult exec$default(SyncVfsFile syncVfsFile, List list, ExecOptions execOptions, int n, Object object) {
        if ((n & 2) != 0) {
            execOptions = new ExecOptions(false, null, null, false, false, false, 63, null);
        }
        return syncVfsFile.exec(list, execOptions);
    }

    @NotNull
    public final ProcessResult exec(@NotNull String cmd, @NotNull List<String> args, @NotNull ExecOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return this.vfs.exec(this.path, cmd, args, options);
    }

    @NotNull
    public final ProcessResult exec(@NotNull String cmd, @NotNull List<String> args, @NotNull Map<String, String> env) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        Intrinsics.checkParameterIsNotNull(env, (String)"env");
        return this.exec(cmd, args, new ExecOptions(false, null, env, false, false, false, 58, null));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ProcessResult exec$default(SyncVfsFile syncVfsFile, String string, List list, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return syncVfsFile.exec(string, (List<String>)list, (Map<String, String>)map);
    }

    @NotNull
    public final ProcessResult exec(@NotNull String cmd, @NotNull String[] args, @NotNull Map<String, String> env) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull(env, (String)"env");
        return this.exec(cmd, (List<String>)ArraysKt.toList((Object[])args), new ExecOptions(false, null, env, false, false, false, 58, null));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ProcessResult exec$default(SyncVfsFile syncVfsFile, String string, String[] stringArray, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return syncVfsFile.exec(string, stringArray, (Map<String, String>)map);
    }

    @NotNull
    public final ProcessResult passthru(@NotNull String cmd, @NotNull List<String> args, @Nullable Function1<? super String, Boolean> filter, @NotNull Map<String, String> env) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        Intrinsics.checkParameterIsNotNull(env, (String)"env");
        return this.exec(cmd, args, new ExecOptions(true, filter, env, false, false, false, 56, null));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ProcessResult passthru$default(SyncVfsFile syncVfsFile, String string, List list, Function1 function1, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        return syncVfsFile.passthru(string, list, (Function1<? super String, Boolean>)function1, (Map<String, String>)map);
    }

    @NotNull
    public final ProcessResult passthru(@NotNull String cmd, @NotNull String[] args, @Nullable Function1<? super String, Boolean> filter, @NotNull Map<String, String> env) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull(env, (String)"env");
        return this.exec(cmd, (List<String>)ArraysKt.toList((Object[])args), new ExecOptions(true, filter, env, false, false, false, 56, null));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ProcessResult passthru$default(SyncVfsFile syncVfsFile, String string, String[] stringArray, Function1 function1, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        return syncVfsFile.passthru(string, stringArray, (Function1<? super String, Boolean>)function1, (Map<String, String>)map);
    }

    @NotNull
    public final String getName() {
        return StringsKt.substringAfterLast$default((String)this.path, (char)'/', null, (int)2, null);
    }

    @NotNull
    public final String getRealpath() {
        return SyncvfsKt.jailCombinePath(this.vfs.getAbsolutePath(), this.path);
    }

    @NotNull
    public final String getRealpathOS() {
        return OS.INSTANCE.isWindows() ? StringsKt.replace$default((String)this.getRealpath(), (char)'/', (char)'\\', (boolean)false, (int)4, null) : this.getRealpath();
    }

    @NotNull
    public final File getRealfile() {
        return new File(this.getRealpathOS());
    }

    @NotNull
    public final Iterable<SyncVfsStat> listdir() {
        return this.vfs.listdir(this.path);
    }

    @NotNull
    public final Iterable<SyncVfsStat> listdirRecursive() {
        return this.listdirRecursive((Function1<? super SyncVfsStat, Boolean>)((Function1)listdirRecursive.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<SyncVfsStat> listdirRecursive(@NotNull Function1<? super SyncVfsStat, Boolean> filter) {
        void $receiver$iv$iv;
        Iterable<SyncVfsStat> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Iterable<SyncVfsStat> iterable = $receiver$iv = this.listdir();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SyncVfsStat it = (SyncVfsStat)element$iv$iv;
            Iterable list$iv$iv = ((Boolean)filter.invoke((Object)it)).booleanValue() ? (it.isDirectory() ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)it), it.getFile().listdirRecursive()) : CollectionsKt.listOf((Object)it)) : CollectionsKt.emptyList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final SyncVfsStat firstRecursive(@NotNull Function1<? super SyncVfsStat, Boolean> filter) {
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        for (SyncVfsStat item : this.listdirRecursive()) {
            if (!((Boolean)filter.invoke((Object)item)).booleanValue()) continue;
            return item;
        }
        Void void_ = ErrorsKt.invalidOp$default("No item on SyncVfsFile.firstRecursive", null, 2, null);
        throw null;
    }

    public final void mkdir() {
        this.vfs.mkdir(this.path);
    }

    public final void rmdir() {
        this.vfs.rmdir(this.path);
    }

    @NotNull
    public final SyncVfsFile ensuredir() {
        if (Intrinsics.areEqual((Object)this.path, (Object)"")) {
            return this;
        }
        if (!SyncvfsKt.getParent(this).getExists()) {
            SyncvfsKt.getParent(this).ensuredir();
        }
        this.mkdir();
        return this;
    }

    @NotNull
    public final SyncVfsFile ensureParentDir() {
        SyncvfsKt.getParent(this).ensuredir();
        return this;
    }

    public final void rmdirRecursively() {
        for (SyncVfsStat item : this.listdir()) {
            if (item.isDirectory()) {
                item.getFile().rmdirRecursively();
                continue;
            }
            item.getFile().remove();
        }
        this.rmdir();
    }

    public final void rmdirRecursivelyIfExists() {
        if (this.getExists()) {
            this.rmdirRecursively();
            return;
        }
    }

    @NotNull
    public final SyncVfsFile access(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new SyncVfsFile(this.vfs, SyncvfsKt.combinePaths(this.path, path));
    }

    @NotNull
    public final SyncVfsFile get(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.access(path);
    }

    public final void set(@NotNull String path, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        String string = content;
        Charset charset = IoKt.getUTF8();
        String string2 = path;
        SyncVfsFile syncVfsFile = this;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        syncVfsFile.set(string2, byArray2);
    }

    public final void set(@NotNull String path, @NotNull ToString content) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        String string = content.toString();
        Charset charset = IoKt.getUTF8();
        String string2 = path;
        SyncVfsFile syncVfsFile = this;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        syncVfsFile.set(string2, byArray2);
    }

    public final void set(@NotNull String path, @NotNull SyncVfsFile content) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.set(path, content.readBytes());
    }

    public final void set(@NotNull String path, @NotNull byte[] content) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        SyncVfsFile file = this.access(path).ensureParentDir();
        if (!file.getExists() || Intrinsics.areEqual((Object)file.read(), (Object)content) ^ true) {
            file.write(content);
        }
    }

    public final boolean contains(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.access(path).getExists();
    }

    @NotNull
    public final SyncVfsFile jailAccess(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.access(path).jail();
    }

    @NotNull
    public final SyncVfsFile jail() {
        return new AccessSyncVfs(this.vfs, this.path).root();
    }

    @NotNull
    public String toString() {
        return "SyncVfsFile(" + this.vfs + ", '" + this.path + "')";
    }

    @NotNull
    public final SyncVfsFile write(@NotNull String data, @NotNull Charset encoding) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        return this.writeString(data, encoding);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SyncVfsFile write$default(SyncVfsFile syncVfsFile, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = IoKt.getUTF8();
        }
        return syncVfsFile.write(string, charset);
    }

    @NotNull
    public final SyncVfsFile writeString(@NotNull String data, @NotNull Charset encoding) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        String string = data;
        SyncVfsFile syncVfsFile = this;
        byte[] byArray = string.getBytes(encoding);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        syncVfsFile.write(byArray2);
        return this;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SyncVfsFile writeString$default(SyncVfsFile syncVfsFile, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = IoKt.getUTF8();
        }
        return syncVfsFile.writeString(string, charset);
    }

    public final void dumpTree() {
        String string = "<dump>";
        System.out.println((Object)string);
        for (SyncVfsStat path : this.listdirRecursive()) {
            System.out.println(path);
        }
        string = "</dump>";
        System.out.println((Object)string);
    }

    public final void copyTo(@NotNull SyncVfsFile that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        that.ensureParentDir().write(this.read());
    }

    public final void copyTreeTo(@NotNull SyncVfsFile that, @NotNull Function2<? super SyncVfsFile, ? super SyncVfsFile, Boolean> filter, boolean doLog) {
        SyncVfsStat stat2;
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        if (doLog) {
            log.INSTANCE.invoke("copyTreeTo " + this.getRealpath() + " -> " + that.getRealpath());
        }
        if ((stat2 = this.stat()).isDirectory()) {
            that.mkdir();
            for (SyncVfsStat node : this.listdir()) {
                node.getFile().copyTreeTo(that.get(node.getName()), filter, doLog);
            }
        } else {
            this.copyTo(that);
        }
    }

    public static /* bridge */ /* synthetic */ void copyTreeTo$default(SyncVfsFile syncVfsFile, SyncVfsFile syncVfsFile2, Function2 function2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = copyTreeTo.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        syncVfsFile.copyTreeTo(syncVfsFile2, (Function2<? super SyncVfsFile, ? super SyncVfsFile, Boolean>)function2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toDumpString() {
        void var3_3;
        SyncVfsStat it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = this.listdirRecursive();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (SyncVfsStat)element$iv$iv;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (SyncVfsStat)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = "// " + it.getPath() + ":" + "\n" + SyncVfsFile.readString$default(it.getFile(), null, 1, null);
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)var3_3), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final SyncVfs getVfs$jtransc_utils_main() {
        return this.vfs;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public SyncVfsFile(@NotNull SyncVfs vfs, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)vfs, (String)"vfs");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.vfs = vfs;
        this.path = path;
    }
}

