/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.vfs;

import com.jtransc.error.ErrorsKt;
import com.jtransc.vfs.FileMode;
import com.jtransc.vfs.IUserData;
import com.jtransc.vfs.MergedSyncVfs;
import com.jtransc.vfs.Path;
import com.jtransc.vfs.RawIo;
import com.jtransc.vfs.ResourcesSyncVfs;
import com.jtransc.vfs.SyncVfs;
import com.jtransc.vfs.SyncVfsFile;
import com.jtransc.vfs.SyncVfsStat;
import com.jtransc.vfs.TarKt;
import com.jtransc.vfs.UserKey;
import com.jtransc.vfs.VfsPath;
import com.jtransc.vfs.ZipSyncVfs;
import com.jtransc.vfs._LocalVfs;
import com.jtransc.vfs._LogSyncVfs;
import com.jtransc.vfs._MemoryVfs;
import com.jtransc.vfs._UrlVfs;
import com.jtransc.vfs.node.FileNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0006\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u001a\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0015\u001a\u00020\u0001\u001a7\u0010\u0015\u001a\u00020\u00012*\u0010\u0016\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00180\u0017\"\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0018\u00a2\u0006\u0002\u0010\u0019\u001a7\u0010\u001a\u001a\u00020\u00012*\u0010\u0016\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u00180\u0017\"\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u0018\u00a2\u0006\u0002\u0010\u0019\u001a\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u000b\u001a\u0018\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u000b\u001a\u0014\u0010 \u001a\u00020\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010\u001a\u0014\u0010\"\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010\u001a\u0012\u0010#\u001a\u00020\u00012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u001a\u0006\u0010$\u001a\u00020\u0001\u001a\u0006\u0010%\u001a\u00020\u0001\u001a\u0006\u0010&\u001a\u00020\u0001\u001a\u000e\u0010'\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*\u001a\u000e\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u000b\u001a\u001b\u0010+\u001a\b\u0012\u0004\u0012\u0002H-0,\"\n\b\u0000\u0010-\u0018\u0001*\u00020.H\u0086\b\u001a\u000e\u0010/\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010/\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u001f\u00100\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0017\"\u00020\u000b\u00a2\u0006\u0002\u00101\u001a\u0016\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b\u001a\u000e\u00105\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b\u001a5\u00106\u001a\u0002H-\"\b\b\u0000\u0010-*\u00020.*\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u0002H-0,2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H-0:\u00a2\u0006\u0002\u0010;\u001a\u0010\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010*\u00020\u0001\u001a\n\u0010=\u001a\u00020\u0001*\u00020\u0001\u001a\u001a\u0010>\u001a\u00020?*\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010>\u001a\u00020?*\u00020\b2\u0006\u0010A\u001a\u00020B2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010C\u001a\u00020\u0001*\u00020\u00012\u0006\u0010D\u001a\u00020\u000b\u001a\u0012\u0010E\u001a\u00020\u0001*\u00020\u00012\u0006\u0010F\u001a\u00020\u000b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006G"}, d2={"parent", "Lcom/jtransc/vfs/SyncVfsFile;", "getParent", "(Lcom/jtransc/vfs/SyncVfsFile;)Lcom/jtransc/vfs/SyncVfsFile;", "withoutExtension", "getWithoutExtension", "CompressedVfs", "file", "Ljava/io/File;", "CwdVfs", "path", "", "GetClassJar", "clazz", "Ljava/lang/Class;", "LocalAndJars", "", "paths", "LocalVfs", "LocalVfsEnsureDirs", "LogVfs", "MemoryVfs", "files", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lcom/jtransc/vfs/SyncVfsFile;", "MemoryVfsBin", "", "MemoryVfsFile", "content", "name", "MemoryVfsFileBin", "MergeVfs", "nodes", "MergedLocalAndJars", "ResourcesVfs", "RootLocalVfs", "RootUrlVfs", "ScriptVfs", "UnjailedLocalVfs", "UrlVfs", "url", "Ljava/net/URL;", "UserKey", "Lcom/jtransc/vfs/UserKey;", "T", "", "ZipVfs", "combinePaths", "([Ljava/lang/String;)Ljava/lang/String;", "jailCombinePath", "base", "access", "normalizePath", "getCached", "Lcom/jtransc/vfs/IUserData;", "key", "builder", "Lkotlin/Function0;", "(Lcom/jtransc/vfs/IUserData;Lcom/jtransc/vfs/UserKey;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getUnmergedFiles", "log", "toSyncStat", "Lcom/jtransc/vfs/SyncVfsStat;", "Lcom/jtransc/vfs/node/FileNode;", "vfs", "Lcom/jtransc/vfs/SyncVfs;", "withBaseName", "baseName", "withExtension", "ext", "jtransc-utils_main"})
public final class SyncvfsKt {
    @NotNull
    public static final SyncVfsStat toSyncStat(@NotNull FileNode $receiver, @NotNull SyncVfs vfs, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)vfs, (String)"vfs");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new SyncVfsStat(new SyncVfsFile(vfs, path), $receiver.size(), $receiver.mtime(), $receiver.isDirectory(), $receiver.isSymlink(), true, $receiver.mode());
    }

    @NotNull
    public static final SyncVfsStat toSyncStat(@NotNull File $receiver, @NotNull SyncVfs vfs, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)vfs, (String)"vfs");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new SyncVfsStat(new SyncVfsFile(vfs, path), $receiver.length(), new Date($receiver.lastModified()), $receiver.isDirectory(), false, true, FileMode.Companion.getFULL_ACCESS());
    }

    @NotNull
    public static final SyncVfsFile RootUrlVfs() {
        return new _UrlVfs().root();
    }

    @NotNull
    public static final SyncVfsFile UrlVfs(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return new _UrlVfs().root().jailAccess(url);
    }

    @NotNull
    public static final SyncVfsFile UrlVfs(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        SyncVfsFile syncVfsFile = new _UrlVfs().root();
        String string = url.toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toExternalForm()");
        return syncVfsFile.jailAccess(string);
    }

    @NotNull
    public static final SyncVfsFile RootLocalVfs() {
        return new _LocalVfs().root();
    }

    @NotNull
    public static final SyncVfsFile MergeVfs(@NotNull List<SyncVfsFile> nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        Collection collection = nodes;
        return !collection.isEmpty() ? new MergedSyncVfs(nodes).root() : SyncvfsKt.MemoryVfs();
    }

    @NotNull
    public static final SyncVfsFile MergedLocalAndJars(@NotNull List<String> paths) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        return SyncvfsKt.MergeVfs(SyncvfsKt.LocalAndJars(paths));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SyncVfsFile> LocalAndJars(@NotNull List<String> paths) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        Iterable iterable = $receiver$iv = (Iterable)paths;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            SyncVfsFile syncVfsFile = StringsKt.endsWith$default((String)it, (String)".jar", (boolean)false, (int)2, null) ? SyncvfsKt.ZipVfs((String)it) : SyncvfsKt.LocalVfs(new File((String)it));
            collection.add(syncVfsFile);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final SyncVfsFile CompressedVfs(@NotNull File file) {
        SyncVfsFile syncVfsFile;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object object = file.getAbsolutePath();
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String npath = string2;
        if (StringsKt.endsWith$default((String)npath, (String)".tar.gz", (boolean)false, (int)2, null)) {
            GZIPInputStream gZIPInputStream;
            object = file;
            GZIPInputStream gZIPInputStream2 = gZIPInputStream;
            GZIPInputStream gZIPInputStream3 = gZIPInputStream;
            FileInputStream fileInputStream = new FileInputStream((File)object);
            gZIPInputStream2(fileInputStream);
            syncVfsFile = TarKt.TarVfs(ByteStreamsKt.readBytes$default((InputStream)gZIPInputStream3, (int)0, (int)1, null));
        } else if (StringsKt.endsWith$default((String)npath, (String)".zip", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)npath, (String)".jar", (boolean)false, (int)2, null)) {
            syncVfsFile = SyncvfsKt.ZipVfs(file);
        } else if (StringsKt.endsWith$default((String)npath, (String)".tar", (boolean)false, (int)2, null)) {
            syncVfsFile = TarKt.TarVfs(file);
        } else {
            Void void_ = ErrorsKt.invalidOp$default("Don't know how to handle compressed file: " + file, null, 2, null);
            throw null;
        }
        return syncVfsFile;
    }

    @NotNull
    public static final SyncVfsFile ZipVfs(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new ZipSyncVfs(new ZipFile(path)).root();
    }

    @NotNull
    public static final SyncVfsFile ZipVfs(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new ZipSyncVfs(new ZipFile(file)).root();
    }

    @NotNull
    public static final SyncVfsFile ResourcesVfs(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return new ResourcesSyncVfs(clazz).root();
    }

    @Deprecated(message="Use File instead", replaceWith=@ReplaceWith(expression="LocalVfs(File(path))", imports={"java.io.File"}))
    @NotNull
    public static final SyncVfsFile LocalVfs(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return SyncvfsKt.RootLocalVfs().access(path).jail();
    }

    @NotNull
    public static final SyncVfsFile UnjailedLocalVfs(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        SyncVfsFile syncVfsFile = SyncvfsKt.RootLocalVfs();
        String string = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
        return syncVfsFile.access(string);
    }

    @NotNull
    public static final SyncVfsFile LocalVfs(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        SyncVfsFile syncVfsFile = new _LocalVfs().root();
        String string = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
        return syncVfsFile.access(string).jail();
    }

    @NotNull
    public static final SyncVfsFile LocalVfsEnsureDirs(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            file.mkdirs();
        }
        catch (Throwable e$iv) {
            e$iv.printStackTrace();
        }
        SyncVfsFile syncVfsFile = new _LocalVfs().root();
        String string = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
        return syncVfsFile.access(string).jail();
    }

    @NotNull
    public static final SyncVfsFile CwdVfs() {
        return SyncvfsKt.LocalVfs(new File(RawIo.INSTANCE.cwd()));
    }

    @NotNull
    public static final SyncVfsFile CwdVfs(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return SyncvfsKt.CwdVfs().jailAccess(path);
    }

    @NotNull
    public static final SyncVfsFile ScriptVfs() {
        return SyncvfsKt.LocalVfs(new File(RawIo.INSTANCE.script()));
    }

    @NotNull
    public static final SyncVfsFile MemoryVfs() {
        return new _MemoryVfs().root();
    }

    @NotNull
    public static final SyncVfsFile MemoryVfs(Pair<String, String> ... files) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        SyncVfsFile vfs = new _MemoryVfs().root();
        for (int i = 0; i < files.length; ++i) {
            Pair<String, String> file = files[i];
            SyncVfsFile.writeString$default(vfs.access((String)file.getFirst()).ensureParentDir(), (String)file.getSecond(), null, 2, null);
        }
        return vfs;
    }

    @NotNull
    public static final File GetClassJar(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        ClassLoader classLoader = VfsPath.class.getClassLoader();
        String classFilePath = StringsKt.replace$default((String)clazz.getName(), (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
        URL classUrl = classLoader.getResource(classFilePath);
        Regex regex = new Regex("^file:(.*?)!(.*?)$");
        String string = classUrl.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classUrl.path");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult == null) {
            Intrinsics.throwNpe();
        }
        MatchResult result2 = matchResult;
        MatchGroup matchGroup = result2.getGroups().get(1);
        if (matchGroup == null) {
            Intrinsics.throwNpe();
        }
        String jarPath = matchGroup.getValue();
        return new File(jarPath);
    }

    @NotNull
    public static final SyncVfsFile MemoryVfsBin(Pair<String, byte[]> ... files) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        SyncVfsFile vfs = new _MemoryVfs().root();
        for (int i = 0; i < files.length; ++i) {
            Pair<String, byte[]> file = files[i];
            vfs.access((String)file.getFirst()).ensureParentDir().write((byte[])file.getSecond());
        }
        return vfs;
    }

    @NotNull
    public static final SyncVfsFile MemoryVfsFile(@NotNull String content, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return SyncvfsKt.MemoryVfs(TuplesKt.to((Object)name, (Object)content)).access(name);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SyncVfsFile MemoryVfsFile$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "file";
        }
        return SyncvfsKt.MemoryVfsFile(string, string2);
    }

    @NotNull
    public static final SyncVfsFile MemoryVfsFileBin(@NotNull byte[] content, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return SyncvfsKt.MemoryVfsBin(TuplesKt.to((Object)name, (Object)content)).access(name);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SyncVfsFile MemoryVfsFileBin$default(byte[] byArray, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "file";
        }
        return SyncvfsKt.MemoryVfsFileBin(byArray, string);
    }

    @NotNull
    public static final SyncVfsFile LogVfs(@NotNull SyncVfsFile parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        return new _LogSyncVfs(parent.jail().getVfs$jtransc_utils_main()).root();
    }

    @NotNull
    public static final SyncVfsFile log(@NotNull SyncVfsFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SyncvfsKt.LogVfs($receiver);
    }

    @NotNull
    public static final String normalizePath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ArrayList<String> out = new ArrayList<String>();
        Iterator iterator = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null), (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null).iterator();
        block10: while (iterator.hasNext()) {
            String chunk;
            switch (chunk = (String)iterator.next()) {
                case "..": {
                    if (out.size() <= 0) continue block10;
                    out.remove(0);
                    break;
                }
                case ".": {
                    break;
                }
                case "": {
                    if (out.size() != 0) continue block10;
                    out.add("");
                    break;
                }
                default: {
                    out.add(chunk);
                }
            }
        }
        return CollectionsKt.joinToString$default((Iterable)out, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String combinePaths(String ... paths) {
        void var3_3;
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        Object[] objectArray = $receiver$iv = (Object[])paths;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            String it = (String)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it, (Object)"") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return SyncvfsKt.normalizePath(CollectionsKt.joinToString$default((Iterable)((List)var3_3), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
    }

    @NotNull
    public static final String jailCombinePath(@NotNull String base, @NotNull String access) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)access, (String)"access");
        return SyncvfsKt.combinePaths(base, SyncvfsKt.normalizePath(access));
    }

    private static final <T> UserKey<T> UserKey() {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"T::class.java.name");
        return new UserKey(string);
    }

    @NotNull
    public static final <T> T getCached(@NotNull IUserData $receiver, @NotNull UserKey<T> key, @NotNull Function0<? extends T> builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        if ($receiver.contains(key) ^ true) {
            $receiver.set(key, builder.invoke());
        }
        T t = $receiver.get(key);
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    @NotNull
    public static final SyncVfsFile getParent(@NotNull SyncVfsFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new SyncVfsFile($receiver.getVfs$jtransc_utils_main(), Path.INSTANCE.parent($receiver.getPath()));
    }

    @NotNull
    public static final SyncVfsFile getWithoutExtension(@NotNull SyncVfsFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new SyncVfsFile($receiver.getVfs$jtransc_utils_main(), Path.INSTANCE.withoutExtension($receiver.getPath()));
    }

    @NotNull
    public static final SyncVfsFile withExtension(@NotNull SyncVfsFile $receiver, @NotNull String ext) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
        return new SyncVfsFile($receiver.getVfs$jtransc_utils_main(), Path.INSTANCE.withExtension($receiver.getPath(), ext));
    }

    @NotNull
    public static final SyncVfsFile withBaseName(@NotNull SyncVfsFile $receiver, @NotNull String baseName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
        return SyncvfsKt.getParent($receiver).access(baseName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SyncVfsFile> getUnmergedFiles(@NotNull SyncVfsFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        SyncVfs vfs = $receiver.getVfs$jtransc_utils_main();
        if (vfs instanceof MergedSyncVfs) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)((MergedSyncVfs)vfs).getNodes();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                SyncVfsFile syncVfsFile = (SyncVfsFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                SyncVfsFile syncVfsFile2 = it.get($receiver.getPath());
                collection.add(syncVfsFile2);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.listOf((Object)$receiver);
    }
}

