/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.vfs;

import com.jtransc.error.ErrorsKt;
import com.jtransc.io.StreamKt;
import com.jtransc.numeric.MultiplesKt;
import com.jtransc.numeric.ParseKt;
import com.jtransc.vfs.BaseTreeVfs;
import com.jtransc.vfs.FileMode;
import com.jtransc.vfs.SyncvfsKt;
import com.jtransc.vfs.TarSyncVfs;
import com.jtransc.vfs.node.FileNode;
import com.jtransc.vfs.node.FileNodeIO;
import com.jtransc.vfs.node.FileNodeTree;
import com.jtransc.vfs.node.FileNodeType;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/jtransc/vfs/TarSyncVfs;", "Lcom/jtransc/vfs/BaseTreeVfs;", "tarData", "", "([B)V", "currentOffset", "", "getCurrentOffset", "()I", "setCurrentOffset", "(I)V", "getTarData", "()[B", "readOne", "", "jtransc-utils_main"})
final class TarSyncVfs
extends BaseTreeVfs {
    private int currentOffset;
    @NotNull
    private final byte[] tarData;

    public final int getCurrentOffset() {
        return this.currentOffset;
    }

    public final void setCurrentOffset(int n) {
        this.currentOffset = n;
    }

    private final boolean readOne() {
        int nodeHeaderOffset = this.currentOffset;
        ByteArrayInputStream header = new ByteArrayInputStream(this.tarData, this.currentOffset, 512);
        String fileName = StreamKt.stringzTrim$default(header, 100, null, 2, null);
        CharSequence charSequence = fileName;
        if (charSequence.length() == 0) {
            return false;
        }
        String fileMode = StreamKt.stringzTrim$default(header, 8, null, 2, null);
        int ownerNumeric = ParseKt.toInt(StreamKt.stringzTrim$default(header, 8, null, 2, null), 8, 0);
        int ownerGroup = ParseKt.toInt(StreamKt.stringzTrim$default(header, 8, null, 2, null), 8, 0);
        String fileSize = StreamKt.stringzTrim$default(header, 12, null, 2, null);
        int lastModification = ParseKt.toInt(StreamKt.stringzTrim$default(header, 12, null, 2, null), 8, 0);
        String checksum = StreamKt.stringzTrim$default(header, 8, null, 2, null);
        String linkIndicator = StreamKt.stringzTrim$default(header, 1, null, 2, null);
        String nameOfLinkedFile = StreamKt.stringzTrim$default(header, 100, null, 2, null);
        long fileSizeLong = Long.parseLong(fileSize, 8);
        CharSequence charSequence2 = nameOfLinkedFile;
        boolean isSymLink = charSequence2.length() > 0;
        charSequence2 = fileName;
        if (charSequence2.length() > 0) {
            FileNode node = this.getTree().getRoot().get(fileName, true);
            node.setType(StringsKt.endsWith$default((String)fileName, (String)"/", (boolean)false, (int)2, null) ? FileNodeType.DIRECTORY : (isSymLink ? FileNodeType.SYMLINK : FileNodeType.FILE));
            Function0<byte[]> readBytes$ = new Function0<byte[]>(this, nodeHeaderOffset, fileSizeLong){
                final /* synthetic */ TarSyncVfs this$0;
                final /* synthetic */ int $nodeHeaderOffset;
                final /* synthetic */ long $fileSizeLong;

                public final byte[] invoke() {
                    return Arrays.copyOfRange(this.this$0.getTarData(), this.$nodeHeaderOffset + 512, this.$nodeHeaderOffset + 512 + (int)this.$fileSizeLong);
                }
                {
                    this.this$0 = tarSyncVfs;
                    this.$nodeHeaderOffset = n;
                    this.$fileSizeLong = l;
                    super(0);
                }
            };
            node.setIo(new FileNodeIO(this, nameOfLinkedFile, isSymLink, fileName, readBytes$, fileSizeLong, lastModification, fileMode){
                final /* synthetic */ TarSyncVfs this$0;
                final /* synthetic */ String $nameOfLinkedFile;
                final /* synthetic */ boolean $isSymLink;
                final /* synthetic */ String $fileName;
                final /* synthetic */ readOne.1 $readBytes;
                final /* synthetic */ long $fileSizeLong;
                final /* synthetic */ int $lastModification;
                final /* synthetic */ String $fileMode;

                @Nullable
                public String readLink() {
                    return this.$nameOfLinkedFile;
                }

                @NotNull
                public byte[] read() {
                    byte[] byArray;
                    if (this.$isSymLink) {
                        byte[] byArray2;
                        try {
                            byArray2 = SyncvfsKt.getParent(this.this$0.root().get(this.$fileName)).get(this.$nameOfLinkedFile).read();
                        }
                        catch (Throwable t) {
                            byArray2 = this.$readBytes.invoke();
                        }
                        byArray = byArray2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"try {\n\t\t\t\t\t\t\tthis@TarSyn\u2026\t\t\t\t\t\treadBytes()\n\t\t\t\t\t\t}");
                    } else {
                        byte[] byArray3 = this.$readBytes.invoke();
                        byArray = byArray3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"readBytes()");
                    }
                    return byArray;
                }

                @NotNull
                public Void write(@NotNull byte[] data) {
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    Void void_ = ErrorsKt.noImpl("Writting not implemented on tar files");
                    throw null;
                }

                public long size() {
                    return this.$fileSizeLong;
                }

                @NotNull
                public Date mtime() {
                    return new Date((long)this.$lastModification * 1000L);
                }

                @NotNull
                public FileMode mode() {
                    return FileMode.Companion.fromOctal(this.$fileMode);
                }
                {
                    this.this$0 = $outer;
                    this.$nameOfLinkedFile = $captured_local_variable$1;
                    this.$isSymLink = $captured_local_variable$2;
                    this.$fileName = $captured_local_variable$3;
                    this.$readBytes = $captured_local_variable$4;
                    this.$fileSizeLong = $captured_local_variable$5;
                    this.$lastModification = $captured_local_variable$6;
                    this.$fileMode = $captured_local_variable$7;
                }
            });
        }
        this.currentOffset = MultiplesKt.nextMultipleOf(this.currentOffset + 512 + (int)fileSizeLong, 512);
        return true;
    }

    @NotNull
    public final byte[] getTarData() {
        return this.tarData;
    }

    public TarSyncVfs(@NotNull byte[] tarData) {
        Intrinsics.checkParameterIsNotNull((Object)tarData, (String)"tarData");
        super(new FileNodeTree());
        this.tarData = tarData;
        while (this.currentOffset < this.tarData.length && this.readOne()) {
        }
    }
}

