/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.vfs.node;

import com.jtransc.vfs.FileMode;
import com.jtransc.vfs.UserData;
import com.jtransc.vfs.node.FileNodeIO;
import com.jtransc.vfs.node.FileNodeTree;
import com.jtransc.vfs.node.FileNodeType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010(\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010)\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00062\b\b\u0002\u0010*\u001a\u00020\u0014J\u0010\u0010+\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00000\u0001J\u001b\u0010.\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00062\b\b\u0002\u0010*\u001a\u00020\u0014H\u0086\u0002J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000000J\u0006\u00101\u001a\u00020\u0014J\u0006\u00102\u001a\u00020\u0014J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000004H\u0096\u0002J\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00000\u0001J\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000209J\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u00020=J\b\u0010>\u001a\u00020\u0006H\u0016R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u000bj\b\u0012\u0004\u0012\u00020\u0000`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006?"}, d2={"Lcom/jtransc/vfs/node/FileNode;", "", "tree", "Lcom/jtransc/vfs/node/FileNodeTree;", "parent", "name", "", "type", "Lcom/jtransc/vfs/node/FileNodeType;", "(Lcom/jtransc/vfs/node/FileNodeTree;Lcom/jtransc/vfs/node/FileNode;Ljava/lang/String;Lcom/jtransc/vfs/node/FileNodeType;)V", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "io", "Lcom/jtransc/vfs/node/FileNodeIO;", "getIo", "()Lcom/jtransc/vfs/node/FileNodeIO;", "setIo", "(Lcom/jtransc/vfs/node/FileNodeIO;)V", "isLeaf", "", "()Z", "getName", "()Ljava/lang/String;", "getParent", "()Lcom/jtransc/vfs/node/FileNode;", "path", "getPath", "root", "getRoot", "getTree", "()Lcom/jtransc/vfs/node/FileNodeTree;", "getType", "()Lcom/jtransc/vfs/node/FileNodeType;", "setType", "(Lcom/jtransc/vfs/node/FileNodeType;)V", "userData", "Lcom/jtransc/vfs/UserData;", "getUserData", "()Lcom/jtransc/vfs/UserData;", "_createChild", "access", "mustCreate", "child", "createChild", "descendants", "get", "getChildren", "", "isDirectory", "isSymlink", "iterator", "", "leafs", "mode", "Lcom/jtransc/vfs/FileMode;", "mtime", "Ljava/util/Date;", "remove", "", "size", "", "toString", "jtransc-utils_main"})
public class FileNode
implements Iterable<FileNode>,
KMappedMarker {
    private final ArrayList<FileNode> children;
    @NotNull
    private final UserData userData;
    @Nullable
    private FileNodeIO io;
    @NotNull
    private final FileNodeTree tree;
    @Nullable
    private final FileNode parent;
    @NotNull
    private final String name;
    @NotNull
    private FileNodeType type;

    @NotNull
    public final UserData getUserData() {
        return this.userData;
    }

    @Nullable
    public final FileNodeIO getIo() {
        return this.io;
    }

    public final void setIo(@Nullable FileNodeIO fileNodeIO) {
        this.io = fileNodeIO;
    }

    @NotNull
    public String toString() {
        return "FileNode(" + this.getPath() + ", type=" + (Object)((Object)this.type) + " leaf=" + this.isLeaf() + ")";
    }

    @NotNull
    public final String getPath() {
        return this.parent != null ? this.parent.getPath() + "/" + this.name : this.name;
    }

    @NotNull
    public final FileNode getRoot() {
        return this.parent != null ? this.parent.getRoot() : this;
    }

    public final boolean isLeaf() {
        return this.children.size() == 0;
    }

    public final long size() {
        FileNodeIO fileNodeIO = this.io;
        return fileNodeIO != null ? fileNodeIO.size() : 0L;
    }

    @NotNull
    public final Date mtime() {
        Object object = this.io;
        if (object == null || (object = ((FileNodeIO)object).mtime()) == null) {
            object = new Date();
        }
        return object;
    }

    @NotNull
    public final FileMode mode() {
        Object object = this.io;
        if (object == null || (object = ((FileNodeIO)object).mode()) == null) {
            object = FileMode.Companion.getFULL_ACCESS();
        }
        return object;
    }

    public final boolean isDirectory() {
        return Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)FileNodeType.ROOT)) || Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)FileNodeType.DIRECTORY));
    }

    public final boolean isSymlink() {
        return Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)FileNodeType.SYMLINK));
    }

    @NotNull
    public final List<FileNode> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public Iterator<FileNode> iterator() {
        Iterator<FileNode> iterator = this.children.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"children.iterator()");
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<FileNode> leafs() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable<FileNode> $receiver$iv;
        Iterable<FileNode> iterable = $receiver$iv = this.descendants();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FileNode it = (FileNode)element$iv$iv;
            if (!it.isLeaf()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<FileNode> descendants() {
        void var3_4;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.children;
        Collection collection = this.children;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FileNode it = (FileNode)element$iv$iv;
            Iterable<FileNode> list$iv$iv = it.descendants();
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        List list = (List)var3_4;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final FileNode child(@NotNull String name) {
        Object v1;
        FileNode fileNode;
        block14: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            switch (name) {
                case "": {
                    fileNode = this;
                    return fileNode;
                }
                case ".": {
                    fileNode = this;
                    return fileNode;
                }
                case "..": {
                    fileNode = this.parent;
                    return fileNode;
                }
            }
            Iterable $receiver$iv = this.children;
            for (Object element$iv : $receiver$iv) {
                FileNode it = (FileNode)element$iv;
                if (!Intrinsics.areEqual((Object)it.name, (Object)name)) continue;
                v1 = element$iv;
                break block14;
            }
            v1 = null;
        }
        fileNode = v1;
        return fileNode;
    }

    @NotNull
    protected FileNode _createChild(@NotNull String name, @NotNull FileNodeType type) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return new FileNode(this.tree, this, name, type);
    }

    @NotNull
    public final FileNode createChild(@NotNull String name, @NotNull FileNodeType type) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        if (this.child(name) != null) {
            throw (Throwable)new FileAlreadyExistsException(new File(name), null, "Child " + name + " already exists", 2, null);
        }
        return this._createChild(name, type);
    }

    @NotNull
    public final FileNode access(@NotNull String path, boolean mustCreate) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileNode node = this;
        boolean first = true;
        for (String name : StringsKt.split$default((CharSequence)path, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null)) {
            FileNode child;
            FileNode fileNode = child = Intrinsics.areEqual((Object)name, (Object)"") && first ? this.getRoot() : node.child(name);
            if (child == null && mustCreate) {
                child = new FileNode(this.tree, node, name, FileNodeType.DIRECTORY);
            }
            if (child == null) {
                throw (Throwable)new NoSuchFileException(new File(path), null, "Can't access '" + path + "' (missing '" + name + "')", 2, null);
            }
            node = child;
            first = false;
        }
        return node;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ FileNode access$default(FileNode fileNode, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: access");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return fileNode.access(string, bl);
    }

    @NotNull
    public final FileNode get(@NotNull String path, boolean mustCreate) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.access(path, mustCreate);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ FileNode get$default(FileNode fileNode, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return fileNode.get(string, bl);
    }

    public final void remove() {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
    }

    @NotNull
    public final FileNodeTree getTree() {
        return this.tree;
    }

    @Nullable
    public final FileNode getParent() {
        return this.parent;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final FileNodeType getType() {
        return this.type;
    }

    public final void setType(@NotNull FileNodeType fileNodeType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fileNodeType), (String)"<set-?>");
        this.type = fileNodeType;
    }

    public FileNode(@NotNull FileNodeTree tree, @Nullable FileNode parent, @NotNull String name, @NotNull FileNodeType type) {
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.tree = tree;
        this.parent = parent;
        this.name = name;
        this.type = type;
        FileNode fileNode = this;
        ArrayList arrayList = new ArrayList();
        fileNode.children = arrayList;
        this.userData = new UserData();
        if (this.parent != null) {
            this.parent.children.add(this);
        }
    }
}

