/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.antkorwin.commonutils.validation.ErrorInfo;
import com.antkorwin.commonutils.validation.Guard;
import com.google.common.collect.Sets;
import com.jupiter.tools.spring.test.mongo.errorinfo.MongoDbErrorInfo;
import com.jupiter.tools.spring.test.mongo.internal.expect.MatchDataSets;
import com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value.DateDynamicValue;
import com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value.DynamicDataSet;
import com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value.DynamicValue;
import com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value.GroovyDynamicValue;
import com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value.JavaScriptDynamicValue;
import com.jupiter.tools.spring.test.mongo.internal.exportdata.ExportFile;
import com.jupiter.tools.spring.test.mongo.internal.exportdata.JsonExport;
import com.jupiter.tools.spring.test.mongo.internal.exportdata.MongoDataExport;
import com.jupiter.tools.spring.test.mongo.internal.exportdata.scanner.DocumentClasses;
import com.jupiter.tools.spring.test.mongo.internal.exportdata.scanner.ReflectionsDocumentScanner;
import com.jupiter.tools.spring.test.mongo.internal.importdata.ImportFile;
import com.jupiter.tools.spring.test.mongo.internal.importdata.JsonImport;
import com.jupiter.tools.spring.test.mongo.internal.importdata.MongoDataImport;
import java.util.Set;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoDbTest {
    private final MongoTemplate mongoTemplate;
    private final DocumentClasses documentClasses;

    public MongoDbTest(MongoTemplate mongoTemplate) {
        Guard.check((mongoTemplate != null ? 1 : 0) != 0, InternalException.class, (ErrorInfo)MongoDbErrorInfo.MONGO_TEMPLATE_IS_MANDATORY);
        this.mongoTemplate = mongoTemplate;
        this.documentClasses = new DocumentClasses(new ReflectionsDocumentScanner(""));
    }

    public void exportTo(String fileName) {
        new ExportFile(new JsonExport(new MongoDataExport(this.mongoTemplate, this.documentClasses))).write(fileName);
    }

    public void importFrom(String fileName) {
        new MongoDataImport(this.mongoTemplate).importFrom(new DynamicDataSet(new JsonImport(new ImportFile(fileName)), this.getDynamicEvaluators()));
    }

    public void expect(String fileName) {
        DynamicDataSet dataSet = new DynamicDataSet(new JsonImport(new ImportFile(fileName)), this.getDynamicEvaluators());
        MongoDataExport mongoData = new MongoDataExport(this.mongoTemplate, this.documentClasses);
        new MatchDataSets(mongoData, dataSet).check();
    }

    private Set<DynamicValue> getDynamicEvaluators() {
        return Sets.newHashSet((Object[])new DynamicValue[]{new GroovyDynamicValue(), new JavaScriptDynamicValue(), new DateDynamicValue()});
    }
}

