/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect;

import com.jupiter.tools.spring.test.mongo.internal.DataSet;
import com.jupiter.tools.spring.test.mongo.internal.expect.graph.AssertGraph;
import com.jupiter.tools.spring.test.mongo.internal.expect.graph.IndexedGraph;
import com.jupiter.tools.spring.test.mongo.internal.expect.graph.MatchGraph;
import com.jupiter.tools.spring.test.mongo.internal.expect.graph.ReachabilityGraph;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class MatchDataSets {
    private final DataSet matched;
    private final DataSet pattern;

    public MatchDataSets(DataSet matched, DataSet pattern) {
        this.matched = matched;
        this.pattern = pattern;
    }

    public void check() {
        Map<String, List<Map<String, Object>>> patternMap = this.pattern.read();
        Map<String, List<Map<String, Object>>> matchedMap = this.matched.read();
        this.assertMatchedCollectionsAllContainsInPattern(matchedMap.keySet(), patternMap.keySet());
        patternMap.keySet().forEach(documentName -> this.checkOneCollection((String)documentName, (List)matchedMap.get(documentName), (List)patternMap.get(documentName)));
    }

    private void checkOneCollection(String documentName, List<Map<String, Object>> matched, List<Map<String, Object>> pattern) {
        this.assertDocumentsCountAreEquals(documentName, matched, pattern);
        new AssertGraph(new IndexedGraph(new ReachabilityGraph(new MatchGraph(documentName, matched, pattern)))).doAssert();
    }

    private void assertDocumentsCountAreEquals(String documentName, List<Map<String, Object>> matched, List<Map<String, Object>> pattern) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)matched.size()).describedAs("expected %d but found %d - %s entities", new Object[]{pattern.size(), matched.size(), documentName})).isEqualTo(pattern.size());
    }

    private void assertMatchedCollectionsAllContainsInPattern(Set<String> matched, Set<String> pattern) {
        Set notFoundCollections = pattern.stream().filter(collection -> !matched.contains(collection)).collect(Collectors.toSet());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)notFoundCollections.isEmpty(), () -> String.format("Not equal document collections:\n expected but not found:\n[%s]", String.join((CharSequence)", ", notFoundCollections)));
    }
}

