/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value;

import com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value.DynamicValue;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.smart.date.TimeDescription;
import java.util.Date;

public class DateDynamicValue
implements DynamicValue {
    @Override
    public boolean isNecessary(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String val = (String)value;
        if (!val.startsWith("date:")) {
            return false;
        }
        return new TimeDescription(this.trimPrefix(val)).matches();
    }

    @Override
    public Object evaluate(Object value) {
        return new TimeDescription(this.trimPrefix((String)value)).getTimeOperation().evaluate(new Date());
    }

    private String trimPrefix(String valueWithPrefix) {
        return valueWithPrefix.replaceFirst("date:", "").replaceAll(" ", "");
    }
}

