/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value;

import com.jupiter.tools.spring.test.mongo.internal.DataSet;
import com.jupiter.tools.spring.test.mongo.internal.expect.ComplexityDataTypes;
import com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value.DynamicValue;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DynamicDataSet
implements DataSet {
    private final DataSet dataSet;
    private final Set<DynamicValue> dynamicValueEvaluators;
    private final ComplexityDataTypes complexityDataTypes;

    public DynamicDataSet(DataSet dataSet, Set<DynamicValue> dynamicValueEvaluators) {
        this.dataSet = dataSet;
        this.dynamicValueEvaluators = dynamicValueEvaluators;
        this.complexityDataTypes = new ComplexityDataTypes();
    }

    @Override
    public Map<String, List<Map<String, Object>>> read() {
        Map<String, List<Map<String, Object>>> evaluatedDataSet = this.dataSet.read();
        for (List<Map<String, Object>> data : evaluatedDataSet.values()) {
            for (Map<String, Object> maps : data) {
                this.applyReplacerToMap(maps);
            }
        }
        return evaluatedDataSet;
    }

    private void applyReplacerToMap(Map<String, Object> maps) {
        for (String key : maps.keySet()) {
            Object value = maps.get(key);
            if (value == null) continue;
            if (!this.complexityDataTypes.isComplexType(value)) {
                for (DynamicValue replacer : this.dynamicValueEvaluators) {
                    if (!replacer.isNecessary(value)) continue;
                    maps.put(key, replacer.evaluate(value));
                }
                continue;
            }
            if (value instanceof Map) {
                this.applyReplacerToMap((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.applyReplacerToList((List)value);
        }
    }

    private void applyReplacerToList(List<Object> listValues) {
        for (int i = 0; i < listValues.size(); ++i) {
            Object value = listValues.get(i);
            if (value instanceof Map) {
                this.applyReplacerToMap((Map)value);
                continue;
            }
            if (value instanceof List) {
                this.applyReplacerToList((List)value);
                continue;
            }
            for (DynamicValue replacer : this.dynamicValueEvaluators) {
                if (!replacer.isNecessary(value)) continue;
                listValues.set(i, replacer.evaluate(value));
            }
        }
    }
}

