/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.graph;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jupiter.tools.spring.test.mongo.internal.expect.graph.Graph;
import com.jupiter.tools.spring.test.mongo.internal.expect.graph.IndexedGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertGraph {
    private final IndexedGraph indexGraph;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Logger log = LoggerFactory.getLogger(AssertGraph.class);
    private boolean failed = false;
    private List<String> errors = new ArrayList<String>();

    public AssertGraph(Graph graph) {
        this.indexGraph = new IndexedGraph(graph);
    }

    public void doAssert() {
        this.validateDataRecords(this.indexGraph.evaluateDataIndexes());
        this.validatePatterns(this.indexGraph.evaluatePatternIndexes());
        if (this.failed) {
            throw new Error("\nExpectedDataSet of " + this.indexGraph.getDocumentName() + " \n\n" + this.errors.stream().collect(Collectors.joining("\n")) + "\n");
        }
    }

    private void validateDataRecords(Set<Integer> indexes) {
        if (indexes.size() != this.indexGraph.dataCount()) {
            String notFoundDataRecords = IntStream.range(0, this.indexGraph.dataCount()).boxed().filter(i -> !indexes.contains(i)).map(this.indexGraph::getDataRecord).map(this::mapToString).collect(Collectors.joining("\n"));
            this.error("Not expected: \n" + notFoundDataRecords + "\n");
        }
    }

    private void validatePatterns(Set<Integer> indexes) {
        if (indexes.size() != this.indexGraph.patternCount()) {
            String notFoundPatterns = IntStream.range(0, this.indexGraph.patternCount()).boxed().filter(i -> !indexes.contains(i)).map(this.indexGraph::getPattern).map(this::mapToString).collect(Collectors.joining("\n"));
            this.error("Expected but not found: \n" + notFoundPatterns + "\n");
        }
    }

    private String mapToString(Map<String, Object> stringObjectMap) {
        try {
            return this.objectMapper.writeValueAsString(stringObjectMap);
        }
        catch (JsonProcessingException e) {
            this.log.error("Error while convert object to string: {}", stringObjectMap, (Object)e);
            throw new InternalException((Throwable)e);
        }
    }

    private void error(String message) {
        this.failed = true;
        this.errors.add(message);
    }
}

