/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.graph;

import com.jupiter.tools.spring.test.mongo.internal.expect.graph.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReachabilityGraph
implements Graph {
    private final Graph graph;
    private final Map<Integer, Integer> finalMatchers;
    private boolean[][] matrix;

    public ReachabilityGraph(Graph graph) {
        this.graph = graph;
        this.finalMatchers = new HashMap<Integer, Integer>();
    }

    @Override
    public boolean[][] calculate() {
        this.matrix = this.graph.calculate();
        for (int i = 0; i < this.matrix.length; ++i) {
            this.processLine(i);
        }
        return this.matrix;
    }

    @Override
    public int dataCount() {
        return this.graph.dataCount();
    }

    @Override
    public int patternCount() {
        return this.graph.patternCount();
    }

    @Override
    public Map<String, Object> getDataRecord(int index) {
        return this.graph.getDataRecord(index);
    }

    @Override
    public Map<String, Object> getPattern(int index) {
        return this.graph.getPattern(index);
    }

    @Override
    public String getDocumentName() {
        return this.graph.getDocumentName();
    }

    private void processLine(int lineNumber) {
        List<Integer> indexes = this.getCorrectMatcherIndexes(lineNumber);
        if (indexes.size() == 1) {
            int indexOfUniqueMatcher = indexes.get(0);
            if (this.finalMatchers.keySet().contains(indexOfUniqueMatcher)) {
                if (this.finalMatchers.get(indexOfUniqueMatcher) != lineNumber) {
                    this.matrix[lineNumber][indexOfUniqueMatcher] = false;
                }
            } else {
                this.finalMatchers.put(indexOfUniqueMatcher, lineNumber);
                this.removeThisMatcherFromOtherLines(lineNumber, indexOfUniqueMatcher);
            }
        }
    }

    private List<Integer> getCorrectMatcherIndexes(int lineNumber) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int length = this.matrix[lineNumber].length;
        for (int matcherIndex = 0; matcherIndex < length; ++matcherIndex) {
            if (!this.matrix[lineNumber][matcherIndex]) continue;
            result.add(matcherIndex);
        }
        return result;
    }

    private void removeThisMatcherFromOtherLines(int lineNumber, int matcherIndex) {
        for (int i = 0; i < this.matrix.length; ++i) {
            if (!this.matrix[i][matcherIndex] || i == lineNumber) continue;
            this.matrix[i][matcherIndex] = false;
            this.processLine(i);
        }
    }
}

