/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.match.simple;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.MatchAny;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.MatchData;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchList
implements MatchData {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final MatchAny matchAny = new MatchAny();
    private final Logger log = LoggerFactory.getLogger(MatchList.class);

    @Override
    public boolean match(Object original, Object expected) {
        List<Object> originalList = this.convertToList(original);
        List<Object> expectedList = this.convertToList(expected);
        if (originalList.size() != expectedList.size()) {
            this.log.error("different array sizes: \n  actual: {}\n  expected: {}", (Object)this.writeObject(original), (Object)this.writeObject(expected));
            return false;
        }
        for (int i = 0; i < originalList.size(); ++i) {
            if (this.matchAny.match(originalList.get(i), expectedList.get(i))) continue;
            return false;
        }
        return true;
    }

    private List<Object> convertToList(Object object) {
        return (List)this.objectMapper.convertValue(object, List.class);
    }

    private String writeObject(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            this.log.error("jackson parsing error", (Throwable)e);
            throw new InternalException("jackson error", Integer.valueOf(104), (Throwable)e);
        }
    }
}

