/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.exportdata;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.jupiter.tools.spring.test.mongo.internal.Text;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFile {
    private final Text text;
    private final Logger log;

    public ExportFile(Text text) {
        this.text = text;
        this.log = LoggerFactory.getLogger(ExportFile.class);
    }

    public void write(String fileName) {
        String textData = this.text.read();
        try {
            Path path = Paths.get(fileName, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, textData.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            this.log.error("Error while save text in file", (Throwable)e);
            throw new InternalException((Throwable)e);
        }
    }
}

