/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.exportdata;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.antkorwin.commonutils.validation.ErrorInfo;
import com.antkorwin.commonutils.validation.Guard;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jupiter.tools.spring.test.mongo.errorinfo.MongoDbErrorInfo;
import com.jupiter.tools.spring.test.mongo.internal.DataSet;
import com.jupiter.tools.spring.test.mongo.internal.exportdata.scanner.DocumentClasses;
import com.jupiter.tools.spring.test.mongo.internal.geo.GeoJsonSerializationModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoDataExport
implements DataSet {
    private final MongoTemplate mongoTemplate;
    private final ObjectMapper objectMapper;
    private final DocumentClasses documentClasses;

    public MongoDataExport(MongoTemplate mongoTemplate, DocumentClasses documentClasses) {
        Guard.check((mongoTemplate != null ? 1 : 0) != 0, InternalException.class, (ErrorInfo)MongoDbErrorInfo.MONGO_TEMPLATE_IS_MANDATORY);
        this.mongoTemplate = mongoTemplate;
        this.documentClasses = documentClasses;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new GeoJsonSerializationModule());
    }

    @Override
    public Map<String, List<Map<String, Object>>> read() {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        for (String name : this.mongoTemplate.getCollectionNames()) {
            List<Map<String, Object>> dataSet = this.getDataSet(name);
            if (dataSet.isEmpty()) continue;
            map.put(this.documentClasses.getDocumentClassName(name), dataSet);
        }
        return map;
    }

    private List<Map<String, Object>> getDataSet(String collectionName) {
        return this.mongoTemplate.findAll(this.documentClasses.getDocumentClass(collectionName)).stream().map(e -> (Map)this.objectMapper.convertValue(e, Map.class)).map(e -> e).collect(Collectors.toList());
    }
}

