/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.junit4;

import com.jupiter.tools.spring.test.mongo.junit4.MongoDbRule;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.test.context.junit4.SpringRunner;
import org.testcontainers.containers.GenericContainer;

@RunWith(value=SpringRunner.class)
@SpringBootTest
public abstract class BaseMongoIT {
    private static final Integer MONGO_PORT = 27017;
    @Autowired
    protected MongoTemplate mongoTemplate;
    @Rule
    public MongoDbRule mongoDbRule = new MongoDbRule(() -> this.mongoTemplate);

    static {
        System.out.println("Start MongoDb testcontainers extension...\n");
        GenericContainer mongo = new GenericContainer("mongo:latest").withExposedPorts(new Integer[]{MONGO_PORT});
        mongo.start();
        System.setProperty("spring.data.mongodb.host", mongo.getContainerIpAddress());
        System.setProperty("spring.data.mongodb.port", mongo.getMappedPort(MONGO_PORT.intValue()).toString());
    }
}

