/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.junit5;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.antkorwin.commonutils.validation.ErrorInfo;
import com.antkorwin.commonutils.validation.Guard;
import com.jupiter.tools.spring.test.mongo.annotation.ExpectedMongoDataSet;
import com.jupiter.tools.spring.test.mongo.annotation.ExportMongoDataSet;
import com.jupiter.tools.spring.test.mongo.annotation.MongoDataSet;
import com.jupiter.tools.spring.test.mongo.errorinfo.MongoDbErrorInfo;
import com.jupiter.tools.spring.test.mongo.internal.MongoDbTest;
import java.io.File;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class MongoDbExtension
implements Extension,
BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private MongoTemplate mongoTemplate;
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"com", "jupiter-tools", "spring-test-mongo", "read-only-dataset"});

    public void beforeAll(ExtensionContext context) throws Exception {
        this.mongoTemplate = (MongoTemplate)SpringExtension.getApplicationContext((ExtensionContext)context).getBean(MongoTemplate.class);
        Guard.check((this.mongoTemplate != null ? 1 : 0) != 0, InternalException.class, (ErrorInfo)MongoDbErrorInfo.MONGO_TEMPLATE_IS_MANDATORY);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        MongoDataSet mongoDataSet = this.getAnnotationFromCurrentMethod(context);
        if (mongoDataSet == null) {
            return;
        }
        if (mongoDataSet.cleanBefore()) {
            this.cleanDataBase();
        }
        if (!mongoDataSet.value().isEmpty()) {
            new MongoDbTest(this.mongoTemplate).importFrom(mongoDataSet.value());
        }
        if (this.isReadOnlyDataSet(context)) {
            File tempFile = File.createTempFile("mongo-test-", "-readonly");
            tempFile.deleteOnExit();
            new MongoDbTest(this.mongoTemplate).exportTo(tempFile.getAbsolutePath());
            context.getStore(NAMESPACE).put((Object)"beforeDataSetFile", (Object)tempFile.getAbsolutePath());
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.expectedDataSet(context);
        this.exportDataSet(context);
        this.cleanAfter(context);
    }

    private void expectedDataSet(ExtensionContext context) {
        if (this.isReadOnlyDataSet(context)) {
            String filePath = (String)context.getStore(NAMESPACE).get((Object)"beforeDataSetFile");
            try {
                new MongoDbTest(this.mongoTemplate).expect(filePath);
            }
            catch (Error e) {
                throw new RuntimeException("Expected ReadOnly dataset, but found some modifications:", e);
            }
            return;
        }
        ExpectedMongoDataSet expectedMongoDataSet = context.getRequiredTestMethod().getAnnotation(ExpectedMongoDataSet.class);
        if (expectedMongoDataSet == null) {
            return;
        }
        new MongoDbTest(this.mongoTemplate).expect(expectedMongoDataSet.value());
    }

    private void cleanAfter(ExtensionContext context) {
        MongoDataSet mongoDataSet = this.getAnnotationFromCurrentMethod(context);
        if (mongoDataSet != null && mongoDataSet.cleanAfter()) {
            this.cleanDataBase();
        }
    }

    private void exportDataSet(ExtensionContext context) {
        ExportMongoDataSet exportMongoDataSet = context.getRequiredTestMethod().getAnnotation(ExportMongoDataSet.class);
        if (exportMongoDataSet == null) {
            return;
        }
        new MongoDbTest(this.mongoTemplate).exportTo(exportMongoDataSet.outputFile());
    }

    private MongoDataSet getAnnotationFromCurrentMethod(ExtensionContext context) {
        return context.getRequiredTestMethod().getAnnotation(MongoDataSet.class);
    }

    private void cleanDataBase() {
        this.mongoTemplate.getCollectionNames().forEach(collectionName -> this.mongoTemplate.remove(new Query(), collectionName));
    }

    private boolean isReadOnlyDataSet(ExtensionContext context) {
        MongoDataSet mongoDataSet = this.getAnnotationFromCurrentMethod(context);
        return mongoDataSet != null && mongoDataSet.readOnly();
    }
}

