/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.authentication;

import com.kaleido.kaptureclient.KaptureClientProperties;
import com.kaleido.kaptureclient.authentication.UserCredentials;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class KaptureJWTRequestInterceptor
implements ClientHttpRequestInterceptor {
    private UserCredentials userCredentials;
    private String kaptureBase;
    private Logger log = LoggerFactory.getLogger(KaptureJWTRequestInterceptor.class);

    public KaptureJWTRequestInterceptor(UserCredentials userCredentials, KaptureClientProperties kaptureClientProperties) {
        this.userCredentials = userCredentials;
        this.kaptureBase = kaptureClientProperties.getBase();
    }

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        if (httpRequest.getURI().toString().contains(this.kaptureBase)) {
            this.log.debug("Intercepting call to {}, setting authorization header", (Object)httpRequest.getURI().toString());
            httpRequest.getHeaders().add("Authorization", "Bearer " + this.userCredentials.getBearerToken());
        }
        return clientHttpRequestExecution.execute(httpRequest, bytes);
    }
}

