/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kaleido.kaptureclient.domain.AltLabel;
import com.kaleido.kaptureclient.domain.ConceptScheme;
import com.kaleido.kaptureclient.domain.Note;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class Concept
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    @NotNull
    private String label;
    @Size(min=3)
    private @Size(min=3) String definition;
    private Boolean retired;
    @JsonIgnore
    private Set<Note> notes = new HashSet<Note>();
    @JsonIgnore
    private Set<AltLabel> synonyms = new HashSet<AltLabel>();
    @NotNull
    private ConceptScheme scheme;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public Concept label(String label) {
        this.label = label;
        return this;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDefinition() {
        return this.definition;
    }

    public Concept definition(String definition) {
        this.definition = definition;
        return this;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public Boolean isRetired() {
        return this.retired;
    }

    public Concept retired(Boolean retired) {
        this.retired = retired;
        return this;
    }

    public void setRetired(Boolean retired) {
        this.retired = retired;
    }

    public Set<Note> getNotes() {
        return this.notes;
    }

    public Concept notes(Set<Note> notes) {
        this.notes = notes;
        return this;
    }

    public Concept addNotes(Note note) {
        this.notes.add(note);
        note.setAnnotatedConcept(this);
        return this;
    }

    public Concept removeNotes(Note note) {
        this.notes.remove(note);
        note.setAnnotatedConcept(null);
        return this;
    }

    public void setNotes(Set<Note> notes) {
        this.notes = notes;
    }

    public Set<AltLabel> getSynonyms() {
        return this.synonyms;
    }

    public Concept synonyms(Set<AltLabel> altLabels) {
        this.synonyms = altLabels;
        return this;
    }

    public Concept addSynonyms(AltLabel altLabel) {
        this.synonyms.add(altLabel);
        altLabel.setSynonymOf(this);
        return this;
    }

    public Concept removeSynonyms(AltLabel altLabel) {
        this.synonyms.remove(altLabel);
        altLabel.setSynonymOf(null);
        return this;
    }

    public void setSynonyms(Set<AltLabel> altLabels) {
        this.synonyms = altLabels;
    }

    public ConceptScheme getScheme() {
        return this.scheme;
    }

    public Concept scheme(ConceptScheme conceptScheme) {
        this.scheme = conceptScheme;
        return this;
    }

    public void setScheme(ConceptScheme conceptScheme) {
        this.scheme = conceptScheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Concept concept = (Concept)o;
        if (concept.getId() == null || this.getId() == null) {
            return false;
        }
        return Objects.equals(this.getId(), concept.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "Concept{id=" + this.getId() + ", label='" + this.getLabel() + "', definition='" + this.getDefinition() + "', retired='" + this.isRetired() + "'}";
    }
}

