/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.kaleido.kaptureclient.domain.Concept;
import com.kaleido.kaptureclient.domain.PlateType;
import com.kaleido.kaptureclient.domain.Scientist;
import com.kaleido.kaptureclient.domain.enumeration.StudyEnvironment;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class Experiment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    @NotNull
    @Pattern(regexp="G\\d+")
    private @NotNull @Pattern(regexp="G\\d+") String name;
    @NotNull
    private StudyEnvironment studyEnvironment;
    private String studyName;
    private LocalDate startDate;
    private String description;
    private String goals;
    @NotNull
    private String location;
    private String chamber;
    private String status;
    @Min(value=0L)
    private @Min(value=0L) Integer numberOfPlates;
    private Double slurryPercent;
    private String notes;
    private String dataRecordName;
    @JsonIgnoreProperties(value={""})
    private Scientist scientist;
    @JsonIgnoreProperties(value={""})
    private Concept processingMethod;
    @Deprecated
    private Set<PlateType> plateTypes = new HashSet<PlateType>();
    private Set<Concept> assayTypes = new HashSet<Concept>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Experiment name(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StudyEnvironment getStudyEnvironment() {
        return this.studyEnvironment;
    }

    public Experiment studyEnvironment(StudyEnvironment studyEnvironment) {
        this.studyEnvironment = studyEnvironment;
        return this;
    }

    public void setStudyEnvironment(StudyEnvironment studyEnvironment) {
        this.studyEnvironment = studyEnvironment;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public Experiment studyName(String studyName) {
        this.studyName = studyName;
        return this;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public Experiment startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public String getDescription() {
        return this.description;
    }

    public Experiment description(String description) {
        this.description = description;
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGoals() {
        return this.goals;
    }

    public Experiment goals(String goals) {
        this.goals = goals;
        return this;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public String getLocation() {
        return this.location;
    }

    public Experiment location(String location) {
        this.location = location;
        return this;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getChamber() {
        return this.chamber;
    }

    public Experiment chamber(String chamber) {
        this.chamber = chamber;
        return this;
    }

    public void setChamber(String chamber) {
        this.chamber = chamber;
    }

    public String getStatus() {
        return this.status;
    }

    public Experiment status(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getNumberOfPlates() {
        return this.numberOfPlates;
    }

    public Experiment numberOfPlates(Integer numberOfPlates) {
        this.numberOfPlates = numberOfPlates;
        return this;
    }

    public void setNumberOfPlates(Integer numberOfPlates) {
        this.numberOfPlates = numberOfPlates;
    }

    public Double getSlurryPercent() {
        return this.slurryPercent;
    }

    public Experiment slurryPercent(Double slurryPercent) {
        this.slurryPercent = slurryPercent;
        return this;
    }

    public void setSlurryPercent(Double slurryPercent) {
        this.slurryPercent = slurryPercent;
    }

    public String getNotes() {
        return this.notes;
    }

    public Experiment notes(String notes) {
        this.notes = notes;
        return this;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getDataRecordName() {
        return this.dataRecordName;
    }

    public Experiment dataRecordName(String dataRecordName) {
        this.dataRecordName = dataRecordName;
        return this;
    }

    public void setDataRecordName(String dataRecordName) {
        this.dataRecordName = dataRecordName;
    }

    public Scientist getScientist() {
        return this.scientist;
    }

    public Experiment scientist(Scientist scientist) {
        this.scientist = scientist;
        return this;
    }

    public void setScientist(Scientist scientist) {
        this.scientist = scientist;
    }

    public Concept getProcessingMethod() {
        return this.processingMethod;
    }

    public Experiment processingMethod(Concept concept) {
        this.processingMethod = concept;
        return this;
    }

    public void setProcessingMethod(Concept concept) {
        this.processingMethod = concept;
    }

    @Deprecated
    public Set<PlateType> getPlateTypes() {
        return this.plateTypes;
    }

    @Deprecated
    public Experiment plateTypes(Set<PlateType> plateTypes) {
        this.plateTypes = plateTypes;
        return this;
    }

    @Deprecated
    public Experiment addPlateTypes(PlateType plateType) {
        this.plateTypes.add(plateType);
        return this;
    }

    @Deprecated
    public Experiment removePlateTypes(PlateType plateType) {
        this.plateTypes.remove(plateType);
        return this;
    }

    @Deprecated
    public void setPlateTypes(Set<PlateType> plateTypes) {
        this.plateTypes = plateTypes;
    }

    public Set<Concept> getAssayTypes() {
        return this.assayTypes;
    }

    public Experiment assayTypes(Set<Concept> concepts) {
        this.assayTypes = concepts;
        return this;
    }

    public Experiment addAssayTypes(Concept concept) {
        this.assayTypes.add(concept);
        return this;
    }

    public Experiment removeAssayTypes(Concept concept) {
        this.assayTypes.remove(concept);
        return this;
    }

    public void setAssayTypes(Set<Concept> concepts) {
        this.assayTypes = concepts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Experiment experiment = (Experiment)o;
        if (experiment.getId() == null || this.getId() == null) {
            return false;
        }
        return Objects.equals(this.getId(), experiment.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "Experiment{id=" + this.getId() + ", name='" + this.getName() + "', studyEnvironment='" + (Object)((Object)this.getStudyEnvironment()) + "', studyName='" + this.getStudyName() + "', startDate='" + this.getStartDate() + "', description='" + this.getDescription() + "', goals='" + this.getGoals() + "', location='" + this.getLocation() + "', chamber='" + this.getChamber() + "', status='" + this.getStatus() + "', numberOfPlates=" + this.getNumberOfPlates() + ", slurryPercent=" + this.getSlurryPercent() + ", notes='" + this.getNotes() + "', dataRecordName='" + this.getDataRecordName() + "'}";
    }
}

