/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient;

import com.kaleido.kaptureclient.KaptureClientProperties;
import com.kaleido.kaptureclient.authentication.KaptureJWTRequestInterceptor;
import com.kaleido.kaptureclient.authentication.UserCredentials;
import com.kaleido.kaptureclient.client.KaptureClient;
import com.kaleido.kaptureclient.client.KaptureClientHTTPException;
import com.kaleido.kaptureclient.client.KaptureResponseErrorHandler;
import com.kaleido.kaptureclient.domain.AltLabel;
import com.kaleido.kaptureclient.domain.Analyte;
import com.kaleido.kaptureclient.domain.AnalyteType;
import com.kaleido.kaptureclient.domain.AssayReadout;
import com.kaleido.kaptureclient.domain.AssayReadoutProperty;
import com.kaleido.kaptureclient.domain.Association;
import com.kaleido.kaptureclient.domain.Authority;
import com.kaleido.kaptureclient.domain.Batch;
import com.kaleido.kaptureclient.domain.BatchAlias;
import com.kaleido.kaptureclient.domain.BatchComponent;
import com.kaleido.kaptureclient.domain.BatchLot;
import com.kaleido.kaptureclient.domain.BatchLotComposition;
import com.kaleido.kaptureclient.domain.ChemicalConcept;
import com.kaleido.kaptureclient.domain.Community;
import com.kaleido.kaptureclient.domain.CommunityComposition;
import com.kaleido.kaptureclient.domain.Concept;
import com.kaleido.kaptureclient.domain.ConceptScheme;
import com.kaleido.kaptureclient.domain.Experiment;
import com.kaleido.kaptureclient.domain.FailedMessage;
import com.kaleido.kaptureclient.domain.ImportedFile;
import com.kaleido.kaptureclient.domain.Media;
import com.kaleido.kaptureclient.domain.MediaLot;
import com.kaleido.kaptureclient.domain.MediaLotComposition;
import com.kaleido.kaptureclient.domain.Monomer;
import com.kaleido.kaptureclient.domain.MonomerComposition;
import com.kaleido.kaptureclient.domain.NmrAssay;
import com.kaleido.kaptureclient.domain.NmrImport;
import com.kaleido.kaptureclient.domain.NmrPeak;
import com.kaleido.kaptureclient.domain.NmrProjection;
import com.kaleido.kaptureclient.domain.NmrSpectra;
import com.kaleido.kaptureclient.domain.Note;
import com.kaleido.kaptureclient.domain.Notebook;
import com.kaleido.kaptureclient.domain.ObservedTaxonomicUnit;
import com.kaleido.kaptureclient.domain.ObservedTaxonomicUnitCount;
import com.kaleido.kaptureclient.domain.OtuCountProperty;
import com.kaleido.kaptureclient.domain.PersistentAuditEvent;
import com.kaleido.kaptureclient.domain.PlateType;
import com.kaleido.kaptureclient.domain.Platemap;
import com.kaleido.kaptureclient.domain.ProcessedReadout;
import com.kaleido.kaptureclient.domain.Sample;
import com.kaleido.kaptureclient.domain.SampleProperty;
import com.kaleido.kaptureclient.domain.Scientist;
import com.kaleido.kaptureclient.domain.SequencingRun;
import com.kaleido.kaptureclient.domain.Supplement;
import com.kaleido.kaptureclient.domain.SupplementMetadata;
import com.kaleido.kaptureclient.domain.User;
import com.kaleido.kaptureclient.domain.Well;
import com.kaleido.kaptureclient.domain.dto.AssayReadoutDTO;
import com.kaleido.kaptureclient.domain.dto.LimsSequencingFileDTO;
import java.util.HashMap;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@SpringBootApplication
@EnableConfigurationProperties(value={KaptureClientProperties.class})
public class KaptureClientConfiguration {
    private KaptureClientProperties kaptureClientProperties;

    public KaptureClientConfiguration(KaptureClientProperties kaptureClientProperties) {
        this.kaptureClientProperties = kaptureClientProperties;
    }

    @Bean
    @Primary
    RestTemplate restTemplate(KaptureJWTRequestInterceptor kaptureJWTRequestInterceptor) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(kaptureJWTRequestInterceptor);
        restTemplate.setErrorHandler((ResponseErrorHandler)new KaptureResponseErrorHandler());
        return restTemplate;
    }

    @Bean
    public RetryTemplate retryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        ExponentialBackOffPolicy exponentialBackOffPolicy = new ExponentialBackOffPolicy();
        exponentialBackOffPolicy.setInitialInterval(this.kaptureClientProperties.getRetryInterval());
        exponentialBackOffPolicy.setMultiplier(this.kaptureClientProperties.getRetryMultiplier());
        exponentialBackOffPolicy.setMaxInterval(this.kaptureClientProperties.getMaxRetryInterval());
        retryTemplate.setBackOffPolicy((BackOffPolicy)exponentialBackOffPolicy);
        HashMap<Class, Boolean> includeExceptions = new HashMap<Class, Boolean>();
        includeExceptions.put(KaptureClientHTTPException.KaptureClientGatewayTimeoutException.class, true);
        includeExceptions.put(KaptureClientHTTPException.KaptureClientBadGatewayException.class, true);
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(this.kaptureClientProperties.getMaxRequestAttempts(), includeExceptions);
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        return retryTemplate;
    }

    @Bean
    KaptureJWTRequestInterceptor kaptureJWTRequestInterceptor(UserCredentials userCredentials) {
        return new KaptureJWTRequestInterceptor(userCredentials, this.kaptureClientProperties);
    }

    @Bean
    KaptureClient<AltLabel> altLabelClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<AltLabel>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getAltLabelEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAltLabelEndpoint(), restTemplate, retryTemplate, AltLabel.class);
    }

    @Bean
    KaptureClient<Analyte> analyteClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Analyte>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getAnalyteEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAnalyteEndpoint(), restTemplate, retryTemplate, Analyte.class);
    }

    @Bean
    KaptureClient<AnalyteType> analyteTypeClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<AnalyteType>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getAnalyteTypeEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAnalyteTypeEndpoint(), restTemplate, retryTemplate, AnalyteType.class);
    }

    @Bean
    KaptureClient<AssayReadout> assayReadoutClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<AssayReadout>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getAssayReadoutEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAssayReadoutEndpoint(), restTemplate, retryTemplate, AssayReadout.class);
    }

    @Bean
    KaptureClient<AssayReadoutProperty> assayReadoutPropertyClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<AssayReadoutProperty>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getAssayReadoutPropertyEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAssayReadoutPropertyEndpoint(), restTemplate, retryTemplate, AssayReadoutProperty.class);
    }

    @Bean
    KaptureClient<Association> associationClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Association>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getAssociationEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAssociationEndpoint(), restTemplate, retryTemplate, Association.class);
    }

    @Bean
    KaptureClient<Authority> authorityClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Authority>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getAuthorityEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAuthorityEndpoint(), restTemplate, retryTemplate, Authority.class);
    }

    @Bean
    KaptureClient<Batch> batchClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Batch>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getBatchEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getBatchEndpoint(), restTemplate, retryTemplate, Batch.class);
    }

    @Bean
    KaptureClient<BatchAlias> batchAliasClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<BatchAlias>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getBatchAliasEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getBatchAliasEndpoint(), restTemplate, retryTemplate, BatchAlias.class);
    }

    @Bean
    KaptureClient<BatchComponent> batchComponentClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<BatchComponent>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getBatchComponentEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getBatchComponentEndpoint(), restTemplate, retryTemplate, BatchComponent.class);
    }

    @Bean
    KaptureClient<BatchLot> batchLotClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<BatchLot>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getBatchLotEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getBatchLotEndpoint(), restTemplate, retryTemplate, BatchLot.class);
    }

    @Bean
    KaptureClient<BatchLotComposition> batchLotCompositionClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<BatchLotComposition>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getBatchLotCompositionEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getBatchLotCompositionEndpoint(), restTemplate, retryTemplate, BatchLotComposition.class);
    }

    @Bean
    KaptureClient<ChemicalConcept> chemicalConceptClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<ChemicalConcept>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getChemicalConceptEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getChemicalConceptEndpoint(), restTemplate, retryTemplate, ChemicalConcept.class);
    }

    @Bean
    KaptureClient<Community> communityClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Community>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getCommunityEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getCommunityEndpoint(), restTemplate, retryTemplate, Community.class);
    }

    @Bean
    KaptureClient<CommunityComposition> communityCompositionClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<CommunityComposition>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getCommunityCompositionEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getCommunityCompositionEndpoint(), restTemplate, retryTemplate, CommunityComposition.class);
    }

    @Bean
    KaptureClient<Concept> conceptClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Concept>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getConceptEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getConceptEndpoint(), restTemplate, retryTemplate, Concept.class);
    }

    @Bean
    KaptureClient<ConceptScheme> conceptSchemeClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<ConceptScheme>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getConceptSchemeEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getConceptSchemeEndpoint(), restTemplate, retryTemplate, ConceptScheme.class);
    }

    @Bean
    KaptureClient<Experiment> experimentClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Experiment>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getExperimentEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getExperimentEndpoint(), restTemplate, retryTemplate, Experiment.class);
    }

    @Bean
    KaptureClient<FailedMessage> failedMessageClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<FailedMessage>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getFailedMessageEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getFailedMessageEndpoint(), restTemplate, retryTemplate, FailedMessage.class);
    }

    @Bean
    KaptureClient<ImportedFile> importedFileClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<ImportedFile>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getImportedFileEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getImportedFileEndpoint(), restTemplate, retryTemplate, ImportedFile.class);
    }

    @Bean
    KaptureClient<Media> mediaClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Media>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getMediaEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getMediaEndpoint(), restTemplate, retryTemplate, Media.class);
    }

    @Bean
    KaptureClient<MediaLot> MediaLotClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<MediaLot>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getMediaLotEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getMediaLotEndpoint(), restTemplate, retryTemplate, MediaLot.class);
    }

    @Bean
    KaptureClient<MediaLotComposition> mediaLotCompositionClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<MediaLotComposition>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getMediaLotCompositionEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getMediaLotCompositionEndpoint(), restTemplate, retryTemplate, MediaLotComposition.class);
    }

    @Bean
    KaptureClient<Monomer> monomerClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Monomer>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getMonomerEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getMonomerEndpoint(), restTemplate, retryTemplate, Monomer.class);
    }

    @Bean
    KaptureClient<MonomerComposition> monomerCompositionClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<MonomerComposition>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getMonomerCompositionEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getMonomerCompositionEndpoint(), restTemplate, retryTemplate, MonomerComposition.class);
    }

    @Bean
    KaptureClient<NmrAssay> nmrAssayClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<NmrAssay>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getNmrAssayEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getNmrAssayEndpoint(), restTemplate, retryTemplate, NmrAssay.class);
    }

    @Bean
    KaptureClient<NmrImport> nmrImportClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<NmrImport>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getNmrImportEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getNmrImportEndpoint(), restTemplate, retryTemplate, NmrImport.class);
    }

    @Bean
    KaptureClient<NmrProjection> nmrProjectionClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<NmrProjection>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getNmrProjectionEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getNmrProjectionEndpoint(), restTemplate, retryTemplate, NmrProjection.class);
    }

    @Bean
    KaptureClient<NmrSpectra> nmrSpectraClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<NmrSpectra>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getNmrSpectraEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getNmrSpectraEndpoint(), restTemplate, retryTemplate, NmrSpectra.class);
    }

    @Bean
    KaptureClient<NmrPeak> nmrPeakClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<NmrPeak>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getNmrPeakEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getNmrPeakEndpoint(), restTemplate, retryTemplate, NmrPeak.class);
    }

    @Bean
    KaptureClient<Note> noteClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Note>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getNoteEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getNoteEndpoint(), restTemplate, retryTemplate, Note.class);
    }

    @Bean
    KaptureClient<Notebook> notebookClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Notebook>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getNotebookEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getNotebookEndpoint(), restTemplate, retryTemplate, Notebook.class);
    }

    @Bean
    KaptureClient<ObservedTaxonomicUnit> observedTaxonomicUnitClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<ObservedTaxonomicUnit>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getObservedTaxonomicUnitEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getObservedTaxonomicUnitEndpoint(), restTemplate, retryTemplate, ObservedTaxonomicUnit.class);
    }

    @Bean
    KaptureClient<ObservedTaxonomicUnitCount> observedTaxonomicUnitCountClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<ObservedTaxonomicUnitCount>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getObservedTaxonomicUnitCountEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getObservedTaxonomicUnitCountEndpoint(), restTemplate, retryTemplate, ObservedTaxonomicUnitCount.class);
    }

    @Bean
    KaptureClient<OtuCountProperty> otuCountPropertyClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<OtuCountProperty>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getOtuCountPropertyEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getOtuCountPropertyEndpoint(), restTemplate, retryTemplate, OtuCountProperty.class);
    }

    @Bean
    KaptureClient<PersistentAuditEvent> persistentAuditEventClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<PersistentAuditEvent>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getPersistentAuditEventEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getPersistentAuditEventEndpoint(), restTemplate, retryTemplate, PersistentAuditEvent.class);
    }

    @Bean
    KaptureClient<PlateType> plateTypeClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<PlateType>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getPlateTypeEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getPlateTypeEndpoint(), restTemplate, retryTemplate, PlateType.class);
    }

    @Bean
    KaptureClient<Platemap> platemapClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Platemap>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getPlatemapEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAnalyteTypeEndpoint(), restTemplate, retryTemplate, Platemap.class);
    }

    @Bean
    KaptureClient<ProcessedReadout> processedReadoutClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<ProcessedReadout>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getProcessedReadoutEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getProcessedReadoutEndpoint(), restTemplate, retryTemplate, ProcessedReadout.class);
    }

    @Bean
    KaptureClient<Sample> sampleClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Sample>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSampleEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAnalyteTypeEndpoint(), restTemplate, retryTemplate, Sample.class);
    }

    @Bean
    KaptureClient<SampleProperty> samplePropertyClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<SampleProperty>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSamplePropertyEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getAnalyteTypeEndpoint(), restTemplate, retryTemplate, SampleProperty.class);
    }

    @Bean
    KaptureClient<Scientist> scientistClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Scientist>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getScientistEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getScientistEndpoint(), restTemplate, retryTemplate, Scientist.class);
    }

    @Bean
    KaptureClient<SequencingRun> sequencingRunClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<SequencingRun>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSequencingRunEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getSequencingRunEndpoint(), restTemplate, retryTemplate, SequencingRun.class);
    }

    @Bean
    KaptureClient<Supplement> supplementClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Supplement>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSupplementEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getSupplementEndpoint(), restTemplate, retryTemplate, Supplement.class);
    }

    @Bean
    KaptureClient<SupplementMetadata> supplementMetadataClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<SupplementMetadata>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSupplementMetadataEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getSupplementMetadataEndpoint(), restTemplate, retryTemplate, SupplementMetadata.class);
    }

    @Bean
    KaptureClient<User> userClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<User>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getUserEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getUserEndpoint(), restTemplate, retryTemplate, User.class);
    }

    @Bean
    KaptureClient<Well> wellClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<Well>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getWellEndpoint(), this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getSearchPathComponent() + "/" + this.kaptureClientProperties.getWellEndpoint(), restTemplate, retryTemplate, Well.class);
    }

    @Bean
    KaptureClient<AssayReadoutDTO> assayReadoutDTOClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<AssayReadoutDTO>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getAssayReadoutDTOEndpoint(), null, restTemplate, retryTemplate, AssayReadoutDTO.class);
    }

    @Bean
    KaptureClient<LimsSequencingFileDTO> limsSequencingFileDTOClient(RestTemplate restTemplate, RetryTemplate retryTemplate) {
        return new KaptureClient<LimsSequencingFileDTO>(this.kaptureClientProperties.getBase() + this.kaptureClientProperties.getLimsSequencingFileDTOEndpoint(), null, restTemplate, retryTemplate, LimsSequencingFileDTO.class);
    }
}

