/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.authentication;

import com.kaleido.kaptureclient.KaptureClientProperties;
import com.kaleido.kaptureclient.authentication.UserCredentials;
import com.kaleido.kaptureclient.authentication.UserToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
@EnableConfigurationProperties(value={KaptureClientProperties.class})
public class AuthClient {
    private RestTemplate restTemplate;
    private String serviceUri;
    public static final String AUTH_ENDPOINT = "authenticate";
    Logger log = LoggerFactory.getLogger(AuthClient.class);

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public AuthClient(KaptureClientProperties kaptureClientProperties) {
        this.serviceUri = kaptureClientProperties.getBase();
        this.restTemplate = new RestTemplate();
    }

    public UserToken getUserToken(UserCredentials userCredentials) {
        this.log.info("getting user token from {}", (Object)(this.serviceUri + AUTH_ENDPOINT));
        UserToken userToken = (UserToken)this.restTemplate.postForObject(this.serviceUri + AUTH_ENDPOINT, (Object)userCredentials, UserToken.class, new Object[0]);
        if (StringUtils.hasText((String)userToken.getBearer())) {
            this.log.info("obtained token");
            this.log.trace("user token: {}", (Object)userToken);
        } else {
            this.log.warn("User token not obtained");
        }
        return userToken;
    }
}

