/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kaleido.kaptureclient.KaptureClientProperties;
import com.kaleido.kaptureclient.authentication.AuthClient;
import com.kaleido.kaptureclient.authentication.UserToken;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UserCredentials {
    public static final long EXPIRATION_BUFFER_MINUTES = 10L;
    public static final String EXPIRY = "exp";
    private String username;
    private String password;
    private AuthClient authClient;
    private String bearerToken = null;
    private Instant bearerExpiry = null;
    Logger log = LoggerFactory.getLogger(UserCredentials.class);

    public UserCredentials(AuthClient authClient, KaptureClientProperties kaptureClientProperties) {
        this.authClient = authClient;
        this.username = kaptureClientProperties.getUsername();
        this.password = kaptureClientProperties.getPassword();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @JsonIgnore
    public String getBearerToken() {
        if (this.bearerToken == null || this.hasTokenExpired()) {
            UserToken userToken = this.authClient.getUserToken(this);
            this.bearerToken = userToken.getBearer();
            this.bearerExpiry = this.getExpiryFromBearer();
        }
        return this.bearerToken;
    }

    public Instant getBearerExpiry() {
        return this.bearerExpiry;
    }

    public void setBearerExpiry(Instant bearerExpiry) {
        this.bearerExpiry = bearerExpiry;
    }

    private Instant getExpiryFromBearer() {
        if (!StringUtils.hasText((String)this.bearerToken)) {
            this.log.error("No Bearer Token has been provieded {}", (Object)this.bearerToken);
            return null;
        }
        try {
            String b64Payload = this.bearerToken.split("\\.")[1];
            Map map = (Map)new ObjectMapper().readValue(new String(Base64.getDecoder().decode(b64Payload)), Map.class);
            this.log.info("Token expires at time: {}", (Object)map.get(EXPIRY).toString());
            return Instant.ofEpochSecond(Long.parseLong(map.get(EXPIRY).toString()));
        }
        catch (IOException | IndexOutOfBoundsException | PatternSyntaxException e) {
            this.log.error("Bearer Token is invalid {}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean hasTokenExpired() {
        if (this.bearerExpiry == null) {
            return true;
        }
        Instant bufferedExpiry = this.bearerExpiry.minus(Duration.ofMinutes(10L));
        Instant currentTime = Instant.now();
        return currentTime.isAfter(bufferedExpiry);
    }
}

