/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.client;

import com.kaleido.kaptureclient.client.ParameterizedTypeImpl;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class KaptureClient<E> {
    private Logger log = LoggerFactory.getLogger(KaptureClient.class);
    @Autowired
    ApplicationContext context;
    private final RetryTemplate retryTemplate;
    private final String endpoint;
    private final String searchEndpoint;
    private final RestTemplate restTemplate;
    private final Class<E> entityClass;
    private static final String PAGE = "page";
    private static final String SIZE = "size";
    public static final String QUERY = "query";
    public static final int DEFAULT_PAGE = 0;
    public static final int DEFAULT_SIZE = Integer.MAX_VALUE;
    private final List<String> fieldsInClass;
    private ParameterizedTypeReference<List<E>> parameterizedTypeReference = new ParameterizedTypeReference<List<E>>(){

        public Type getType() {
            return new ParameterizedTypeImpl((ParameterizedType)super.getType(), new Type[]{KaptureClient.this.entityClass});
        }
    };

    public KaptureClient(String endpoint, String searchEndpoint, RestTemplate restTemplate, RetryTemplate retryTemplate, Class<E> entityClass) {
        this.endpoint = endpoint;
        this.searchEndpoint = searchEndpoint;
        this.restTemplate = restTemplate;
        this.entityClass = entityClass;
        this.retryTemplate = retryTemplate;
        this.fieldsInClass = new ArrayList<String>();
        ReflectionUtils.doWithFields(entityClass, field -> {
            this.fieldsInClass.add(field.getName());
            if (Arrays.stream(field.getType().getDeclaredFields()).anyMatch(f -> f.getName().equals("id"))) {
                String fieldName = field.getName() + "Id";
                this.fieldsInClass.add(fieldName);
            }
        });
    }

    public String getEntityClassName() {
        return this.entityClass.toString();
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public ResponseEntity<List<E>> findByFieldEquals(String fieldName, String fieldValue) {
        return this.findByFieldsEqual(Collections.singletonMap(fieldName, fieldValue));
    }

    public ResponseEntity<List<E>> findByFieldEquals(String fieldName, String fieldValue, int pageNumber, int pageSize) {
        return this.findByFieldsEqual(Collections.singletonMap(fieldName, fieldValue), pageNumber, pageSize);
    }

    public ResponseEntity<List<E>> findByFieldsEqual(Map<String, String> fieldValueMap) {
        return this.findByFieldsEqual(fieldValueMap, 0, Integer.MAX_VALUE);
    }

    public ResponseEntity<List<E>> findByFieldsEqual(Map<String, String> fieldValueMap, int pageNumber, int pageSize) {
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> {
            this.checkSearchFields(fieldValueMap.keySet());
            return this.restTemplate.exchange(this.findByFieldsEqualUri(fieldValueMap, pageNumber, pageSize), HttpMethod.GET, null, this.parameterizedTypeReference);
        });
    }

    public ResponseEntity<List<E>> findByFieldWithOperator(String fieldName, String fieldValue, String operator) {
        return this.findByFieldWithOperator(fieldName, fieldValue, operator, 0, Integer.MAX_VALUE);
    }

    public ResponseEntity<List<E>> findByFieldWithOperator(String fieldName, String fieldValue, String operator, int pageNumber, int pageSize) {
        Map<String, String> operatorMap = Stream.of({"operator", operator}, {"value", fieldValue}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
        return this.findByFieldsWithOperators(Collections.singletonMap(fieldName, operatorMap), pageNumber, pageSize);
    }

    public ResponseEntity<List<E>> findByFieldsWithOperators(Map<String, Map<String, String>> fieldValOperatorMap) {
        return this.findByFieldsWithOperators(fieldValOperatorMap, 0, Integer.MAX_VALUE);
    }

    public ResponseEntity<List<E>> findByFieldsWithOperators(Map<String, Map<String, String>> fieldValOperatorMap, int pageNumber, int pageSize) {
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> {
            this.checkSearchFields(fieldValOperatorMap.keySet());
            return this.restTemplate.exchange(this.findByFieldsWithOperatorsUri(fieldValOperatorMap, pageNumber, pageSize), HttpMethod.GET, null, this.parameterizedTypeReference);
        });
    }

    private void checkSearchFields(Set<String> strings) {
        Map<Boolean, List<String>> partitions = strings.stream().collect(Collectors.partitioningBy(this.fieldsInClass::contains));
        if (partitions.get(Boolean.FALSE).size() > 0) {
            this.log.warn("{} does not contain the fields: {}", this.entityClass, (Object)StringUtils.collectionToCommaDelimitedString((Collection)partitions.get(Boolean.FALSE)));
        }
    }

    public ResponseEntity<E> find(Long entityId) {
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> this.restTemplate.getForEntity(this.endpoint + "/" + entityId, this.entityClass, new Object[0]));
    }

    public ResponseEntity<E> findOneByMethod(String methodName, String value) {
        String uri = this.endpoint + "/" + methodName + (value != null ? "/" + value : "/");
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> this.restTemplate.getForEntity(uri, this.entityClass, new Object[0]));
    }

    public ResponseEntity<List<E>> findAllByMethod(String methodName, String value) {
        String uri = this.endpoint + "/" + methodName + (value != null ? "/" + value : "/");
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> this.restTemplate.exchange(uri, HttpMethod.GET, null, this.parameterizedTypeReference, new Object[0]));
    }

    public ResponseEntity<List<E>> findAll() {
        return this.findAll(0, Integer.MAX_VALUE);
    }

    public ResponseEntity<List<E>> findAll(int pageNumber, int pageSize) {
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> this.restTemplate.exchange(this.findByFieldsEqualUri(Collections.EMPTY_MAP, pageNumber, pageSize), HttpMethod.GET, null, this.parameterizedTypeReference));
    }

    public ResponseEntity<E> save(@Valid E entity) {
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> {
            try {
                Long id = (Long)new PropertyDescriptor("id", this.entityClass).getReadMethod().invoke(entity, new Object[0]);
                if (id == null) {
                    return this.restTemplate.postForEntity(this.endpoint, entity, this.entityClass, new Object[0]);
                }
                HttpEntity httpEntity = new HttpEntity(entity);
                return this.restTemplate.exchange(this.endpoint, HttpMethod.PUT, httpEntity, this.entityClass, new Object[0]);
            }
            catch (IntrospectionException | ReflectiveOperationException e) {
                this.log.error("Error accessing ID of entity {}", entity);
                throw new RuntimeException(e);
            }
        });
    }

    public ResponseEntity<List<E>> saveAll(@Valid List<E> entityList) {
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> {
            HttpEntity requestEntity = new HttpEntity((Object)entityList);
            return this.restTemplate.exchange(this.endpoint + "/save-all", HttpMethod.POST, requestEntity, new ParameterizedTypeReference<List<E>>(){}, new Object[0]);
        });
    }

    public ResponseEntity<List<E>> postToEndpoint(@Valid E entity, String endpointSuffix) {
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> {
            HttpEntity requestEntity = new HttpEntity(entity);
            return this.restTemplate.exchange(this.endpoint + endpointSuffix, HttpMethod.POST, requestEntity, new ParameterizedTypeReference<List<E>>(){}, new Object[0]);
        });
    }

    public void delete(Long entityId) {
        this.retryTemplate.execute(arg0 -> {
            this.restTemplate.delete(this.endpoint + "/{id}", new Object[]{entityId});
            return null;
        });
    }

    public ResponseEntity<List<E>> findByName(String name) {
        return this.findByName(name, 0, Integer.MAX_VALUE);
    }

    public ResponseEntity<List<E>> findByName(String name, int pageNumber, int pageSize) {
        return this.findByFieldEquals("name", name, pageNumber, pageSize);
    }

    public Optional<E> findFirstByName(String name) {
        List body = (List)this.findByName(name, 0, 1).getBody();
        return Optional.ofNullable(body == null ? null : (body.size() > 0 ? body.get(0) : null));
    }

    public ResponseEntity<List<E>> findByLabel(String label) {
        return this.findByFieldEquals("label", label);
    }

    public ResponseEntity<List<E>> findByLabel(String label, int pageNumber, int pageSize) {
        return this.findByFieldEquals("label", label, pageNumber, pageSize);
    }

    public Optional<E> findFirstByLabel(String label) {
        List body = (List)this.findByLabel(label, 0, 1).getBody();
        return Optional.ofNullable(body == null ? null : (body.size() > 0 ? body.get(0) : null));
    }

    public ResponseEntity<List<E>> search(String query) {
        return this.search(query, 0, Integer.MAX_VALUE);
    }

    public ResponseEntity<List<E>> search(String query, int pageNumber, int pageSize) {
        return (ResponseEntity)this.retryTemplate.execute(arg0 -> {
            URI searchUri = this.searchUri(query, pageNumber, pageSize);
            return this.restTemplate.exchange(searchUri, HttpMethod.GET, null, this.parameterizedTypeReference);
        });
    }

    protected URI findByFieldEqualsUri(String fieldName, String value) {
        return this.findByFieldsEqualUri(Collections.singletonMap(fieldName, value), 0, Integer.MAX_VALUE);
    }

    protected URI findByFieldsEqualUri(Map<String, String> fieldValMap, int pageNumber, int pageSize) {
        DefaultUriBuilderFactory factory = new DefaultUriBuilderFactory();
        factory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.VALUES_ONLY);
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.endpoint);
        fieldValMap.forEach((key, value) -> builder.queryParam(key + ".equals", new Object[]{"{" + key + "}"}));
        builder.queryParam(PAGE, new Object[]{pageNumber}).queryParam(SIZE, new Object[]{pageSize});
        String uriTemplate = builder.build().toUriString();
        return factory.uriString(uriTemplate).build(fieldValMap);
    }

    protected URI findByFieldWithOperatorUri(String fieldName, String value, String operator) {
        return this.findByFieldWithOperatorUri(fieldName, value, operator, 0, Integer.MAX_VALUE);
    }

    protected URI findByFieldWithOperatorUri(String fieldName, String value, String operator, int pageNumber, int pageSize) {
        Map<String, String> operatorMap = Stream.of({"operator", operator}, {"value", value}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
        return this.findByFieldsWithOperatorsUri(Collections.singletonMap(fieldName, operatorMap), pageNumber, pageSize);
    }

    protected URI findByFieldsWithOperatorsUri(Map<String, Map<String, String>> fieldValOperatorMap, int pageNumber, int pageSize) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.endpoint);
        fieldValOperatorMap.forEach((key, value) -> builder.queryParam(key + "." + (String)value.get("operator"), new Object[]{value.get("value")}));
        builder.queryParam(PAGE, new Object[]{pageNumber}).queryParam(SIZE, new Object[]{pageSize});
        return builder.build().toUri();
    }

    protected URI searchUri(String query, int pageNumber, int pageSize) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.searchEndpoint);
        return builder.queryParam(QUERY, new Object[]{query}).queryParam(PAGE, new Object[]{pageNumber}).queryParam(SIZE, new Object[]{pageSize}).build().toUri();
    }

    public KaptureClient getClient(Class entityClass) throws ClassCastException {
        String beanName = StringUtils.uncapitalize((String)entityClass.getSimpleName()) + "Client";
        return (KaptureClient)this.context.getBean(beanName);
    }
}

