/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.client;

import com.kaleido.kaptureclient.client.KaptureClientHTTPException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;

public class KaptureResponseErrorHandler
implements ResponseErrorHandler {
    private Logger log = LoggerFactory.getLogger(KaptureResponseErrorHandler.class);

    public boolean hasError(ClientHttpResponse httpResponse) throws IOException {
        return httpResponse.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR || httpResponse.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse httpResponse) throws IOException {
        if (httpResponse.getStatusCode().equals((Object)HttpStatus.BAD_GATEWAY)) {
            throw new KaptureClientHTTPException.KaptureClientBadGatewayException(httpResponse.getStatusCode());
        }
        if (httpResponse.getStatusCode().equals((Object)HttpStatus.GATEWAY_TIMEOUT)) {
            throw new KaptureClientHTTPException.KaptureClientGatewayTimeoutException(httpResponse.getStatusCode());
        }
        if (httpResponse.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR) {
            throw new HttpServerErrorException(httpResponse.getStatusCode(), httpResponse.getStatusText());
        }
        if (httpResponse.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR) {
            throw new HttpClientErrorException(httpResponse.getStatusCode(), httpResponse.getStatusText());
        }
    }
}

