/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kaleido.kaptureclient.domain.Concept;
import com.kaleido.kaptureclient.domain.Note;
import com.kaleido.kaptureclient.domain.enumeration.AssociationType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;

public class Association
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    @NotNull
    private AssociationType predicate;
    @JsonIgnore
    private Set<Note> notes = new HashSet<Note>();
    @NotNull
    private Concept subject;
    @NotNull
    private Concept object;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AssociationType getPredicate() {
        return this.predicate;
    }

    public Association predicate(AssociationType predicate) {
        this.predicate = predicate;
        return this;
    }

    public void setPredicate(AssociationType predicate) {
        this.predicate = predicate;
    }

    public Set<Note> getNotes() {
        return this.notes;
    }

    public Association notes(Set<Note> notes) {
        this.notes = notes;
        return this;
    }

    public Association addNotes(Note note) {
        this.notes.add(note);
        note.setAnnotatedAssociation(this);
        return this;
    }

    public Association removeNotes(Note note) {
        this.notes.remove(note);
        note.setAnnotatedAssociation(null);
        return this;
    }

    public void setNotes(Set<Note> notes) {
        this.notes = notes;
    }

    public Concept getSubject() {
        return this.subject;
    }

    public Association subject(Concept concept) {
        this.subject = concept;
        return this;
    }

    public void setSubject(Concept concept) {
        this.subject = concept;
    }

    public Concept getObject() {
        return this.object;
    }

    public Association object(Concept concept) {
        this.object = concept;
        return this;
    }

    public void setObject(Concept concept) {
        this.object = concept;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Association association = (Association)o;
        if (association.getId() == null || this.getId() == null) {
            return false;
        }
        return Objects.equals(this.getId(), association.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "Association{id=" + this.getId() + ", predicate='" + (Object)((Object)this.getPredicate()) + "'}";
    }
}

