/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.kaleido.kaptureclient.domain.CommunityComposition;
import com.kaleido.kaptureclient.domain.Concept;
import com.kaleido.kaptureclient.domain.Media;
import com.kaleido.kaptureclient.domain.Scientist;
import com.kaleido.kaptureclient.domain.enumeration.CommunityType;
import com.kaleido.kaptureclient.domain.enumeration.GeneralQuestion;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;

public class Community
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    @NotNull
    private String name;
    private CommunityType communityType;
    private String barcode;
    private String description;
    private String alias;
    private String species;
    private String source;
    private GeneralQuestion typed;
    private GeneralQuestion knownAntibioticResistance;
    private String plasmid;
    private GeneralQuestion starterStocksMade;
    private String dataRecordName;
    private ZonedDateTime registrationDate;
    private String bsiId;
    private String bsiName;
    private String notes;
    private Scientist scientist;
    @JsonIgnoreProperties(value={""})
    private Concept sourceType;
    @JsonIgnoreProperties(value={""})
    private Community relatedCommunity;
    @JsonIgnoreProperties(value={""})
    private String status;
    @JsonIgnoreProperties(value={""})
    private Media growthMedium;
    @JsonIgnoreProperties(value={""})
    private String pathogen;
    @JsonIgnoreProperties(value={""})
    private String gramStain;
    @JsonIgnoreProperties(value={""})
    private String growthRequirement;
    private Set<Concept> antibioticLists = new HashSet<Concept>();
    private Set<CommunityComposition> communityCompositions = new HashSet<CommunityComposition>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Community name(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CommunityType getCommunityType() {
        return this.communityType;
    }

    public Community communityType(CommunityType communityType) {
        this.communityType = communityType;
        return this;
    }

    public void setCommunityType(CommunityType communityType) {
        this.communityType = communityType;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public Community barcode(String barcode) {
        this.barcode = barcode;
        return this;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getDescription() {
        return this.description;
    }

    public Community description(String description) {
        this.description = description;
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAlias() {
        return this.alias;
    }

    public Community alias(String alias) {
        this.alias = alias;
        return this;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getSpecies() {
        return this.species;
    }

    public Community species(String species) {
        this.species = species;
        return this;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getSource() {
        return this.source;
    }

    public Community source(String source) {
        this.source = source;
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public GeneralQuestion getTyped() {
        return this.typed;
    }

    public Community typed(GeneralQuestion typed) {
        this.typed = typed;
        return this;
    }

    public void setTyped(GeneralQuestion typed) {
        this.typed = typed;
    }

    public GeneralQuestion getKnownAntibioticResistance() {
        return this.knownAntibioticResistance;
    }

    public Community knownAntibioticResistance(GeneralQuestion knownAntibioticResistance) {
        this.knownAntibioticResistance = knownAntibioticResistance;
        return this;
    }

    public void setKnownAntibioticResistance(GeneralQuestion knownAntibioticResistance) {
        this.knownAntibioticResistance = knownAntibioticResistance;
    }

    public String getPlasmid() {
        return this.plasmid;
    }

    public Community plasmid(String plasmid) {
        this.plasmid = plasmid;
        return this;
    }

    public void setPlasmid(String plasmid) {
        this.plasmid = plasmid;
    }

    public GeneralQuestion getStarterStocksMade() {
        return this.starterStocksMade;
    }

    public Community starterStocksMade(GeneralQuestion starterStocksMade) {
        this.starterStocksMade = starterStocksMade;
        return this;
    }

    public void setStarterStocksMade(GeneralQuestion starterStocksMade) {
        this.starterStocksMade = starterStocksMade;
    }

    public String getDataRecordName() {
        return this.dataRecordName;
    }

    public Community dataRecordName(String dataRecordName) {
        this.dataRecordName = dataRecordName;
        return this;
    }

    public void setDataRecordName(String dataRecordName) {
        this.dataRecordName = dataRecordName;
    }

    public ZonedDateTime getRegistrationDate() {
        return this.registrationDate;
    }

    public Community registrationDate(ZonedDateTime registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    public void setRegistrationDate(ZonedDateTime registrationDate) {
        this.registrationDate = registrationDate;
    }

    public String getBsiId() {
        return this.bsiId;
    }

    public Community bsiId(String bsiId) {
        this.bsiId = bsiId;
        return this;
    }

    public void setBsiId(String bsiId) {
        this.bsiId = bsiId;
    }

    public String getBsiName() {
        return this.bsiName;
    }

    public Community bsiName(String bsiName) {
        this.bsiName = bsiName;
        return this;
    }

    public void setBsiName(String bsiName) {
        this.bsiName = bsiName;
    }

    public String getNotes() {
        return this.notes;
    }

    public Community notes(String notes) {
        this.notes = notes;
        return this;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Scientist getScientist() {
        return this.scientist;
    }

    public Community scientist(Scientist scientist) {
        this.scientist = scientist;
        return this;
    }

    public void setScientist(Scientist scientist) {
        this.scientist = scientist;
    }

    public Concept getSourceType() {
        return this.sourceType;
    }

    public Community sourceType(Concept concept) {
        this.sourceType = concept;
        return this;
    }

    public void setSourceType(Concept concept) {
        this.sourceType = concept;
    }

    public Community getRelatedCommunity() {
        return this.relatedCommunity;
    }

    public Community relatedCommunity(Community community) {
        this.relatedCommunity = community;
        return this;
    }

    public void setRelatedCommunity(Community community) {
        this.relatedCommunity = community;
    }

    public String getStatus() {
        return this.status;
    }

    public Community status(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(String concept) {
        this.status = this.status;
    }

    public Media getGrowthMedium() {
        return this.growthMedium;
    }

    public Community growthMedium(Media media) {
        this.growthMedium = media;
        return this;
    }

    public void setGrowthMedium(Media media) {
        this.growthMedium = media;
    }

    public String getPathogen() {
        return this.pathogen;
    }

    public Community pathogen(String pathogen) {
        this.pathogen = pathogen;
        return this;
    }

    public void setPathogen(String pathogen) {
        this.pathogen = pathogen;
    }

    public String getGramStain() {
        return this.gramStain;
    }

    public Community gramStain(String gramStain) {
        this.gramStain = gramStain;
        return this;
    }

    public void setGramStain(String gramStain) {
        this.gramStain = gramStain;
    }

    public String getGrowthRequirement() {
        return this.growthRequirement;
    }

    public Community growthRequirement(String growthRequirement) {
        this.growthRequirement = growthRequirement;
        return this;
    }

    public void setGrowthRequirement(String growthRequirement) {
        this.growthRequirement = growthRequirement;
    }

    public Set<Concept> getAntibioticLists() {
        return this.antibioticLists;
    }

    public Community antibioticLists(Set<Concept> concepts) {
        this.antibioticLists = concepts;
        return this;
    }

    public Community addAntibioticList(Concept concept) {
        this.antibioticLists.add(concept);
        return this;
    }

    public Community removeAntibioticList(Concept concept) {
        this.antibioticLists.remove(concept);
        return this;
    }

    public void setAntibioticLists(Set<Concept> concepts) {
        this.antibioticLists = concepts;
    }

    public Set<CommunityComposition> getCommunityCompositions() {
        return this.communityCompositions;
    }

    public Community communityCompositions(Set<CommunityComposition> communityCompositions) {
        this.communityCompositions = communityCompositions;
        return this;
    }

    public Community addCommunityComposition(CommunityComposition communityComposition) {
        this.communityCompositions.add(communityComposition);
        return this;
    }

    public Community removeCommunityComposition(CommunityComposition communityComposition) {
        this.communityCompositions.remove(communityComposition);
        return this;
    }

    public void setCommunityCompositions(Set<CommunityComposition> communityCompositions) {
        this.communityCompositions = communityCompositions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Community community = (Community)o;
        if (community.getId() == null || this.getId() == null) {
            return false;
        }
        return Objects.equals(this.getId(), community.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "Community{id=" + this.getId() + ", name='" + this.getName() + "', communityType='" + (Object)((Object)this.getCommunityType()) + "', barcode='" + this.getBarcode() + "', description='" + this.getDescription() + "', alias='" + this.getAlias() + "', species='" + this.getSpecies() + "', source='" + this.getSource() + "', typed='" + (Object)((Object)this.getTyped()) + "', knownAntibioticResistance='" + (Object)((Object)this.getKnownAntibioticResistance()) + "', plasmid='" + this.getPlasmid() + "', starterStocksMade='" + (Object)((Object)this.getStarterStocksMade()) + "', dataRecordName='" + this.getDataRecordName() + "', registrationDate='" + this.getRegistrationDate() + "', bsiId='" + this.getBsiId() + "', bsiName='" + this.getBsiName() + "', notes='" + this.getNotes() + "', sourceType='" + this.getSourceType() + "', status='" + this.getStatus() + "', growthRequirement='" + this.getGrowthRequirement() + "', pathogen='" + this.getPathogen() + "', gramStain='" + this.getGramStain() + "'}";
    }
}

