/*
 * Decompiled with CFR 0.152.
 */
package com.kaleido.kaptureclient.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kaleido.kaptureclient.domain.AbstractAuditingEntity;
import com.kaleido.kaptureclient.domain.Authority;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class User
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    @NotNull
    @Size(min=1, max=50)
    private @NotNull @Size(min=1, max=50) String login;
    @JsonIgnore
    @NotNull
    @Size(min=60, max=60)
    private @NotNull @Size(min=60, max=60) String password;
    @Size(max=50)
    private @Size(max=50) String firstName;
    @Size(max=50)
    private @Size(max=50) String lastName;
    @Email
    @Size(min=5, max=254)
    private @Email @Size(min=5, max=254) String email;
    @NotNull
    private boolean activated = false;
    @Size(min=2, max=6)
    private @Size(min=2, max=6) String langKey;
    @Size(max=256)
    private @Size(max=256) String imageUrl;
    @Size(max=20)
    @JsonIgnore
    private @Size(max=20) String activationKey;
    @Size(max=20)
    @JsonIgnore
    private @Size(max=20) String resetKey;
    private Instant resetDate = null;
    @JsonIgnore
    private Set<Authority> authorities = new HashSet<Authority>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login.toLowerCase(Locale.ENGLISH);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public boolean getActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String activationKey) {
        this.activationKey = activationKey;
    }

    public String getResetKey() {
        return this.resetKey;
    }

    public void setResetKey(String resetKey) {
        this.resetKey = resetKey;
    }

    public Instant getResetDate() {
        return this.resetDate;
    }

    public void setResetDate(Instant resetDate) {
        this.resetDate = resetDate;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public void setLangKey(String langKey) {
        this.langKey = langKey;
    }

    public Set<Authority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Set<Authority> authorities) {
        this.authorities = authorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return user.getId() != null && this.getId() != null && Objects.equals(this.getId(), user.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "User{login='" + this.login + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", email='" + this.email + '\'' + ", imageUrl='" + this.imageUrl + '\'' + ", activated='" + this.activated + '\'' + ", langKey='" + this.langKey + '\'' + ", activationKey='" + this.activationKey + '\'' + "}";
    }
}

