/*
 * Decompiled with CFR 0.152.
 */
package com.kangaroohy.oss.configuration;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.kangaroohy.oss.configuration.OssProperties;
import com.kangaroohy.oss.service.OssTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnClass(value={OssTemplate.class})
@ConditionalOnProperty(prefix="kangaroohy.oss", value={"enabled"}, matchIfMissing=true)
public class OssAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AmazonS3.class})
    public AmazonS3 amazonS3(OssProperties properties) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(properties.getEndpoint(), properties.getRegion());
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(properties.getAccessKey(), properties.getSecretKey());
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfiguration)).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(properties.getPathStyleAccess())).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={OssTemplate.class})
    @ConditionalOnBean(value={AmazonS3.class})
    public OssTemplate ossService(OssProperties properties, AmazonS3 amazonS3) {
        return new OssTemplate(properties, amazonS3);
    }
}

