/*
 * Decompiled with CFR 0.152.
 */
package com.kangaroohy.oss.enums;

public enum PolicyType {
    READ_ONLY("\u53ea\u8bfb", "{\n    \"Version\": \"2012-10-17\",\n    \"Statement\": [\n        {\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Action\": [\n                \"s3:GetBucketLocation\"\n            ],\n            \"Resource\": [\n                \"arn:aws:s3:::my-defaultBucketName\"\n            ]\n        },\n        {\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Action\": [\n                \"s3:ListBucket\"\n            ],\n            \"Resource\": [\n                \"arn:aws:s3:::my-defaultBucketName\"\n            ],\n            \"Condition\": {\n                \"StringEquals\": {\n                    \"s3:prefix\": [\n                        \"*\"\n                    ]\n                }\n            }\n        },\n        {\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Action\": [\n                \"s3:GetObject\"\n            ],\n            \"Resource\": [\n                \"arn:aws:s3:::my-defaultBucketName/**\"\n            ]\n        }\n    ]\n}"),
    WRITE_ONLY("\u53ea\u5199", "{\n    \"Version\": \"2012-10-17\",\n    \"Statement\": [\n        {\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Action\": [\n                \"s3:GetBucketLocation\",\n                \"s3:ListBucketMultipartUploads\"\n            ],\n            \"Resource\": [\n                \"arn:aws:s3:::my-defaultBucketName\"\n            ]\n        },\n        {\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Action\": [\n                \"s3:PutObject\",\n                \"s3:AbortMultipartUpload\",\n                \"s3:DeleteObject\",\n                \"s3:ListMultipartUploadParts\"\n            ],\n            \"Resource\": [\n                \"arn:aws:s3:::my-defaultBucketName/**\"\n            ]\n        }\n    ]\n}"),
    READ_WRITE("\u53ef\u8bfb\u53ef\u5199", "{\n    \"Version\": \"2012-10-17\",\n    \"Statement\": [\n        {\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Action\": [\n                \"s3:GetBucketLocation\",\n                \"s3:ListBucketMultipartUploads\"\n            ],\n            \"Resource\": [\n                \"arn:aws:s3:::my-defaultBucketName\"\n            ]\n        },\n        {\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Action\": [\n                \"s3:ListBucket\"\n            ],\n            \"Resource\": [\n                \"arn:aws:s3:::my-defaultBucketName\"\n            ],\n            \"Condition\": {\n                \"StringEquals\": {\n                    \"s3:prefix\": [\n                        \"*\"\n                    ]\n                }\n            }\n        },\n        {\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Action\": [\n                \"s3:ListMultipartUploadParts\",\n                \"s3:PutObject\",\n                \"s3:AbortMultipartUpload\",\n                \"s3:DeleteObject\",\n                \"s3:GetObject\"\n            ],\n            \"Resource\": [\n                \"arn:aws:s3:::my-defaultBucketName/**\"\n            ]\n        }\n    ]\n}");

    private final String desc;
    private final String policy;
    private static final String MY_DEFAULT_BUCKET_NAME = "my-defaultBucketName";

    private PolicyType(String desc, String policy) {
        this.desc = desc;
        this.policy = policy;
    }

    public static String getPolicy(PolicyType policyType, String bucketName) {
        return policyType.getPolicy().replace(MY_DEFAULT_BUCKET_NAME, bucketName);
    }

    public String getDesc() {
        return this.desc;
    }

    public String getPolicy() {
        return this.policy;
    }
}

