/*
 * Decompiled with CFR 0.152.
 */
package com.kangaroohy.oss.service;

import com.amazonaws.HttpMethod;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.kangaroohy.oss.configuration.OssProperties;
import com.kangaroohy.oss.entity.MultiPartUploadInfo;
import com.kangaroohy.oss.enums.PolicyType;
import com.kangaroohy.oss.utils.CustomUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OssTemplate {
    private final OssProperties ossProperties;
    private final AmazonS3 amazonS3;

    public OssTemplate(OssProperties ossProperties, AmazonS3 amazonS3) {
        this.ossProperties = ossProperties;
        this.amazonS3 = amazonS3;
    }

    public boolean existBucket(String bucketName) {
        return this.amazonS3.doesBucketExistV2(bucketName);
    }

    public boolean createBucket(String bucketName) {
        if (!this.amazonS3.doesBucketExistV2(bucketName)) {
            Bucket bucket = this.amazonS3.createBucket(bucketName);
            return bucket.getName() != null;
        }
        return true;
    }

    public boolean createBucket(String bucketName, PolicyType policyType) {
        boolean created = this.createBucket(bucketName);
        if (created) {
            this.amazonS3.setBucketPolicy(bucketName, PolicyType.getPolicy(policyType, bucketName));
        }
        return created;
    }

    public List<Bucket> getAllBuckets() {
        return this.amazonS3.listBuckets();
    }

    public Optional<Bucket> getBucket(String bucketName) {
        return this.amazonS3.listBuckets().stream().filter(b -> b.getName().equals(bucketName)).findFirst();
    }

    public void removeBucket(String bucketName) {
        this.amazonS3.deleteBucket(bucketName);
    }

    public List<S3ObjectSummary> getAllObjectsByPrefix(String prefix) {
        return this.getAllObjectsByPrefix(this.getBucketName(), prefix);
    }

    public List<S3ObjectSummary> getAllObjectsByPrefix(String bucketName, String prefix) {
        ObjectListing objectListing = this.amazonS3.listObjects(bucketName, prefix);
        return new ArrayList<S3ObjectSummary>(objectListing.getObjectSummaries());
    }

    public String getPresignedObjectPutUrl(String objectName) {
        return this.getPresignedObjectPutUrl(this.getBucketName(), objectName);
    }

    public String getPresignedObjectPutUrl(String bucketName, String objectName) {
        return this.getPresignedObjectPutUrl(bucketName, objectName, 10);
    }

    public String getPresignedObjectPutUrl(String bucketName, String objectName, Integer time) {
        return this.getPresignedObjectPutUrl(bucketName, objectName, time, TimeUnit.MINUTES);
    }

    public String getPresignedObjectPutUrl(String bucketName, String objectName, Integer time, TimeUnit timeUnit) {
        return this.getObjectUrl(bucketName, objectName, time, timeUnit, HttpMethod.PUT);
    }

    public String getObjectUrl(String objectName) {
        return this.getObjectUrl(this.getBucketName(), objectName);
    }

    public String getObjectUrl(String bucketName, String objectName) {
        URL url = this.amazonS3.getUrl(bucketName, objectName);
        return url.toString();
    }

    public String getObjectUrl(String objectName, Integer time) {
        return this.getObjectUrl(this.getBucketName(), objectName, time);
    }

    public String getObjectUrl(String bucketName, String objectName, Integer time) {
        return this.getObjectUrl(bucketName, objectName, time, TimeUnit.MINUTES);
    }

    public String getObjectUrl(String bucketName, String objectName, Integer time, TimeUnit timeUnit) {
        return this.getObjectUrl(bucketName, objectName, time, timeUnit, HttpMethod.GET);
    }

    public String getObjectUrl(String bucketName, String objectName, Integer time, TimeUnit timeUnit, HttpMethod method) {
        GeneratePresignedUrlRequest presignedUrlRequest = new GeneratePresignedUrlRequest(bucketName, objectName).withMethod(method).withExpiration(CustomUtil.formDuration(time, timeUnit));
        URL url = this.amazonS3.generatePresignedUrl(presignedUrlRequest);
        return url.toString();
    }

    public PutObjectResult putObject(String objectName, InputStream stream) throws IOException {
        return this.putObject(this.getBucketName(), objectName, stream);
    }

    public PutObjectResult putObject(String bucketName, String objectName, InputStream stream) throws IOException {
        return this.putObject(bucketName, objectName, stream, stream.available(), "application/octet-stream");
    }

    public PutObjectResult putObject(String bucketName, String objectName, String contextType, InputStream stream) throws IOException {
        return this.putObject(bucketName, objectName, stream, stream.available(), contextType);
    }

    public PutObjectResult putObject(String bucketName, String objectName, InputStream stream, int size, String contextType) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength((long)size);
        objectMetadata.setContentType(contextType);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, objectName, stream, objectMetadata);
        putObjectRequest.getRequestClientOptions().setReadLimit(size + 1);
        return this.amazonS3.putObject(putObjectRequest);
    }

    public S3Object getObjectInfo(String objectName) {
        return this.getObjectInfo(this.getBucketName(), objectName);
    }

    public S3Object getObjectInfo(String bucketName, String objectName) {
        return this.amazonS3.getObject(bucketName, objectName);
    }

    public S3Object getObject(String objectName) {
        return this.getObject(this.getBucketName(), objectName);
    }

    public S3Object getObject(String bucketName, String objectName) {
        return this.amazonS3.getObject(bucketName, objectName);
    }

    public void removeObject(String objectName) {
        this.removeObject(this.getBucketName(), objectName);
    }

    public void removeObject(String bucketName, String objectName) {
        this.amazonS3.deleteObject(bucketName, objectName);
    }

    public MultiPartUploadInfo getPresignedMultipartUploadUrls(String objectName, Integer partSize) {
        return this.getPresignedMultipartUploadUrls(objectName, partSize, "application/octet-stream");
    }

    public MultiPartUploadInfo getPresignedMultipartUploadUrls(String objectName, Integer partSize, String contentType) {
        return this.getPresignedMultipartUploadUrls(this.getBucketName(), objectName, partSize, contentType);
    }

    public MultiPartUploadInfo getPresignedMultipartUploadUrls(String bucketName, String objectName, Integer partSize, String contentType) {
        return this.getPresignedMultipartUploadUrls(bucketName, objectName, partSize, contentType, 10);
    }

    public MultiPartUploadInfo getPresignedMultipartUploadUrls(String bucketName, String objectName, Integer partSize, String contentType, Integer time) {
        return this.getPresignedMultipartUploadUrls(bucketName, objectName, partSize, contentType, time, TimeUnit.MINUTES);
    }

    public MultiPartUploadInfo getPresignedMultipartUploadUrls(String bucketName, String objectName, Integer partSize, String contentType, Integer time, TimeUnit timeUnit) {
        String uploadId;
        ArrayList<String> partUrlList = new ArrayList<String>();
        try {
            InitiateMultipartUploadResult multipartUploadResult = this.initiateMultipartUpload(bucketName, objectName);
            uploadId = multipartUploadResult.getUploadId();
            GeneratePresignedUrlRequest presignedUrlRequest = new GeneratePresignedUrlRequest(bucketName, objectName).withMethod(HttpMethod.PUT).withContentType(contentType).withExpiration(CustomUtil.formDuration(time, timeUnit));
            presignedUrlRequest.addRequestParameter("uploadId", uploadId);
            for (int i = 1; i <= partSize; ++i) {
                presignedUrlRequest.addRequestParameter("partNumber", String.valueOf(i));
                URL url = this.amazonS3.generatePresignedUrl(presignedUrlRequest);
                partUrlList.add(url.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return MultiPartUploadInfo.builder().uploadId(uploadId).fileName(objectName).expiryTime(CustomUtil.getLocalDateTime(time, timeUnit)).uploadUrls(partUrlList).build();
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(String objectName) {
        return this.initiateMultipartUpload(this.getBucketName(), objectName);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(String bucketName, String objectName) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(bucketName, objectName);
        return this.amazonS3.initiateMultipartUpload(initiateMultipartUploadRequest);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(String bucketName, String objectName, String contentType) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(contentType);
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(bucketName, objectName, objectMetadata);
        return this.amazonS3.initiateMultipartUpload(initiateMultipartUploadRequest);
    }

    public UploadPartResult uploadPart(String uploadId, String objectName, String md5Digest, int partNumber, long partSize, InputStream inputStream) {
        return this.uploadPart(this.getBucketName(), uploadId, objectName, md5Digest, partNumber, partSize, inputStream);
    }

    public UploadPartResult uploadPart(String bucketName, String uploadId, String objectName, String md5Digest, int partNumber, long partSize, InputStream inputStream) {
        UploadPartRequest uploadPartRequest = new UploadPartRequest().withBucketName(bucketName).withUploadId(uploadId).withKey(objectName).withMD5Digest(md5Digest).withPartNumber(partNumber).withPartSize(partSize).withInputStream(inputStream);
        return this.amazonS3.uploadPart(uploadPartRequest);
    }

    public PartListing listParts(String objectName, String uploadId) {
        return this.listParts(this.getBucketName(), objectName, uploadId);
    }

    public PartListing listParts(String bucketName, String objectName, String uploadId) {
        ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, objectName, uploadId);
        return this.amazonS3.listParts(listPartsRequest);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(String objectName, String uploadId) {
        return this.completeMultipartUpload(this.getBucketName(), objectName, uploadId);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(String bucketName, String objectName, String uploadId) {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        PartListing partListing = this.listParts(bucketName, objectName, uploadId);
        List parts = partListing.getParts();
        if (!parts.isEmpty()) {
            for (PartSummary summary : parts) {
                partETags.add(new PartETag(summary.getPartNumber(), summary.getETag()));
            }
        }
        return this.completeMultipartUpload(bucketName, objectName, uploadId, partETags);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(String bucketName, String objectName, String uploadId, List<PartETag> partETags) {
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, objectName, uploadId, partETags);
        return this.amazonS3.completeMultipartUpload(completeMultipartUploadRequest);
    }

    public void abortMultipartUpload(String objectName, String uploadId) {
        this.abortMultipartUpload(this.getBucketName(), objectName, uploadId);
    }

    public void abortMultipartUpload(String bucketName, String objectName, String uploadId) {
        AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, objectName, uploadId);
        this.amazonS3.abortMultipartUpload(abortMultipartUploadRequest);
    }

    public MultipartUploadListing listMultipartUploads() {
        return this.listMultipartUploads(this.getBucketName());
    }

    public MultipartUploadListing listMultipartUploads(String bucketName) {
        ListMultipartUploadsRequest listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
        return this.amazonS3.listMultipartUploads(listMultipartUploadsRequest);
    }

    public String getBucketName() {
        if (this.ossProperties.getBucketName() == null) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u9ed8\u8ba4 BucketName");
        }
        return this.ossProperties.getBucketName();
    }

    public String getGatewayUrl(String objectName) {
        return this.getGatewayUrl(this.getBucketName(), objectName);
    }

    public String getGatewayUrl(String bucketName, String objectName) {
        if (StringUtils.hasText((String)this.ossProperties.getCustomDomain())) {
            return this.ossProperties.getCustomDomain() + "/" + objectName;
        }
        String url = this.ossProperties.getEndpoint() + "/" + bucketName;
        if (this.ossProperties.getPathStyleAccess().equals(Boolean.FALSE)) {
            url = CustomUtil.convertToVirtualHostEndpoint(URI.create(this.ossProperties.getEndpoint()), bucketName).toString();
        }
        return url + "/" + objectName;
    }
}

