/*
 * Decompiled with CFR 0.152.
 */
package com.kangaroohy.oss.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class CustomUtil {
    private CustomUtil() {
    }

    public static Date formDuration(Duration duration) {
        return Date.from(Instant.now().plus(duration));
    }

    public static Date formDuration(Integer time, TimeUnit timeUnit) {
        return Date.from(Instant.now().plus(CustomUtil.getDuration(time, timeUnit)));
    }

    public static Date formLocalDateTime(Integer time, TimeUnit timeUnit) {
        return Date.from(CustomUtil.getLocalDateTime(time, timeUnit).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Duration getDuration(Integer time, TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                return Duration.ofDays(time.intValue());
            }
            case HOURS: {
                return Duration.ofHours(time.intValue());
            }
            case MINUTES: {
                return Duration.ofMinutes(time.intValue());
            }
            case SECONDS: {
                return Duration.ofSeconds(time.intValue());
            }
            case MILLISECONDS: {
                return Duration.ofMillis(time.intValue());
            }
            case NANOSECONDS: {
                return Duration.ofNanos(time.intValue());
            }
        }
        throw new UnsupportedOperationException("Man, use a real TimeUnit unit");
    }

    public static LocalDateTime getLocalDateTime(Integer time, TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                return LocalDateTime.now().plusDays(time.intValue());
            }
            case HOURS: {
                return LocalDateTime.now().plusHours(time.intValue());
            }
            case MINUTES: {
                return LocalDateTime.now().plusMinutes(time.intValue());
            }
            case SECONDS: {
                return LocalDateTime.now().plusSeconds(time.intValue());
            }
        }
        throw new UnsupportedOperationException("Man, use a real TimeUnit unit");
    }

    public static URI convertToVirtualHostEndpoint(URI endpoint, String bucketName) {
        try {
            return new URI(String.format("%s://%s.%s", endpoint.getScheme(), bucketName, endpoint.getAuthority()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid bucket name: " + bucketName, e);
        }
    }
}

