/*
 * Decompiled with CFR 0.152.
 */
package com.kanyun.kace.gradle;

import com.kanyun.kace.gradle.KaceGenerateAction;
import com.kanyun.kace.gradle.KaceGenerateTask;
import com.kanyun.kace.gradle.LayoutItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangedFiles;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0007J\u0018\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u00020&2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020-00H\u0002J\u0018\u00101\u001a\u00020+2\u0006\u0010'\u001a\u00020(2\u0006\u00102\u001a\u00020\u0004H\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020-002\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020-H\u0002R\u0016\u0010\u0003\u001a\u00020\u00048QX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000bR\u0014\u0010!\u001a\u00020\"8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u00067"}, d2={"Lcom/kanyun/kace/gradle/KaceGenerateTask;", "Lorg/gradle/api/DefaultTask;", "()V", "androidLayoutResources", "Lorg/gradle/api/file/FileCollection;", "getAndroidLayoutResources$kace_gradle_plugin", "()Lorg/gradle/api/file/FileCollection;", "blackList", "Lorg/gradle/api/provider/ListProperty;", "", "getBlackList", "()Lorg/gradle/api/provider/ListProperty;", "layoutDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLayoutDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "layoutVariantMap", "Lorg/gradle/api/provider/MapProperty;", "getLayoutVariantMap", "()Lorg/gradle/api/provider/MapProperty;", "namespace", "Lorg/gradle/api/provider/Property;", "getNamespace", "()Lorg/gradle/api/provider/Property;", "projectName", "getProjectName", "()Ljava/lang/String;", "sourceOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getSourceOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "whiteList", "getWhiteList", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "action", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "cleanTargetDir", "changeFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles;", "destDir", "Ljava/io/File;", "deleteGeneratedFile", "removeFiles", "", "getChangedFiles", "layoutResources", "getChangedLayoutList", "getLayoutItem", "Lcom/kanyun/kace/gradle/LayoutItem;", "file", "kace-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nKaceGenerateTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaceGenerateTask.kt\ncom/kanyun/kace/gradle/KaceGenerateTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,157:1\n1517#2:158\n1588#2,3:159\n1819#2,2:162\n734#2:166\n825#2,2:167\n734#2:169\n825#2,2:170\n1819#2,2:172\n1753#2,3:174\n13506#3,2:164\n*S KotlinDebug\n*F\n+ 1 KaceGenerateTask.kt\ncom/kanyun/kace/gradle/KaceGenerateTask\n*L\n84#1:158\n84#1:159,3\n85#1:162,2\n114#1:166\n114#1:167,2\n117#1:169\n117#1:170,2\n123#1:172,2\n145#1:174,3\n102#1:164,2\n*E\n"})
public abstract class KaceGenerateTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection layoutDirs;
    @NotNull
    private final FileCollection androidLayoutResources;
    @NotNull
    private final String projectName;

    public KaceGenerateTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"files(...)");
        this.layoutDirs = configurableFileCollection;
        FileTree fileTree = this.layoutDirs.getAsFileTree().matching(arg_0 -> KaceGenerateTask.androidLayoutResources$lambda$0(androidLayoutResources.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"matching(...)");
        this.androidLayoutResources = (FileCollection)fileTree;
        String string = this.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.projectName = string;
    }

    @Internal
    @NotNull
    public final ConfigurableFileCollection getLayoutDirs() {
        return this.layoutDirs;
    }

    @Incremental
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public FileCollection getAndroidLayoutResources$kace_gradle_plugin() {
        return this.androidLayoutResources;
    }

    @Input
    @NotNull
    public abstract MapProperty<String, String> getLayoutVariantMap();

    @Input
    @NotNull
    public abstract Property<String> getNamespace();

    @Input
    @NotNull
    public abstract ListProperty<String> getWhiteList();

    @Input
    @NotNull
    public abstract ListProperty<String> getBlackList();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getSourceOutputDir();

    @Internal
    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action(@NotNull InputChanges inputChanges) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        long startTime = System.currentTimeMillis();
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        File destDir = (File)this.getSourceOutputDir().getAsFile().get();
        ChangedFiles changeFiles = this.getChangedFiles(inputChanges, this.getAndroidLayoutResources$kace_gradle_plugin());
        Intrinsics.checkNotNull((Object)destDir);
        this.cleanTargetDir(changeFiles, destDir);
        List<File> changedLayoutList = this.getChangedLayoutList(changeFiles);
        Iterable $this$map$iv = changedLayoutList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getLayoutItem((File)it));
        }
        List changedLayoutItemList = (List)destination$iv$iv;
        Iterable $this$forEach$iv = changedLayoutItemList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LayoutItem item = (LayoutItem)element$iv;
            boolean bl = false;
            workQueue.submit(KaceGenerateAction.class, arg_0 -> KaceGenerateTask.action$lambda$3$lambda$2((Function1)new Function1<KaceGenerateAction.Parameters, Unit>(destDir, item, this){
                final /* synthetic */ File $destDir;
                final /* synthetic */ LayoutItem $item;
                final /* synthetic */ KaceGenerateTask this$0;
                {
                    this.$destDir = $destDir;
                    this.$item = $item;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(KaceGenerateAction.Parameters parameters) {
                    parameters.getDestDir().set(this.$destDir);
                    parameters.getLayoutFile().set(this.$item.getLayoutFile());
                    parameters.getVariantName().set((Object)this.$item.getVariantName());
                    parameters.getNamespace().set((Provider)this.this$0.getNamespace());
                }
            }, arg_0));
        }
        workQueue.await();
        long duration = System.currentTimeMillis() - startTime;
        this.getLogger().info(changedLayoutItemList.size() + " layouts are processed at " + this.projectName + " Project, which takes " + duration + "ms");
    }

    private final void cleanTargetDir(ChangedFiles changeFiles, File destDir) {
        block2: {
            block1: {
                if (!(changeFiles instanceof ChangedFiles.Known)) break block1;
                this.deleteGeneratedFile(((ChangedFiles.Known)changeFiles).getRemoved());
                break block2;
            }
            File[] fileArray = destDir.listFiles();
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                FilesKt.deleteRecursively((File)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getChangedLayoutList(ChangedFiles changeFiles) {
        Iterable $this$filter$iv;
        List layoutFileList = new ArrayList();
        if (changeFiles instanceof ChangedFiles.Known) {
            layoutFileList.addAll(((ChangedFiles.Known)changeFiles).getModified());
        } else {
            CollectionsKt.addAll((Collection)layoutFileList, (Iterable)((Iterable)this.getAndroidLayoutResources$kace_gradle_plugin()));
        }
        Object object = this.getWhiteList().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Collection collection = (Collection)object;
        if (!collection.isEmpty()) {
            void $this$filterTo$iv$iv;
            $this$filter$iv = layoutFileList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!((List)this.getWhiteList().get()).contains(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Object object2 = this.getBlackList().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        $this$filter$iv = (Collection)object2;
        if (!$this$filter$iv.isEmpty()) {
            $this$filter$iv = layoutFileList;
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!(!((List)this.getBlackList().get()).contains(it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return layoutFileList;
    }

    private final void deleteGeneratedFile(List<? extends File> removeFiles) {
        Iterable $this$forEach$iv = removeFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            LayoutItem item = this.getLayoutItem(file);
            if (!item.getTargetDir().exists()) continue;
            FilesKt.deleteRecursively((File)item.getTargetDir());
        }
    }

    private final LayoutItem getLayoutItem(File file) {
        File destDir = (File)this.getSourceOutputDir().getAsFile().get();
        String parentDir = file.getParentFile().getAbsolutePath();
        String string = (String)((Map)this.getLayoutVariantMap().get()).get(parentDir);
        if (string == null) {
            string = "main";
        }
        String layoutVariantName = string;
        Intrinsics.checkNotNull((Object)destDir);
        return new LayoutItem(destDir, file, layoutVariantName, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ChangedFiles getChangedFiles(InputChanges inputChanges, FileCollection layoutResources) {
        ChangedFiles changedFiles;
        if (!inputChanges.isIncremental()) {
            changedFiles = (ChangedFiles)new ChangedFiles.Unknown();
        } else {
            void $this$fold$iv;
            Iterable iterable = inputChanges.getFileChanges(layoutResources);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getFileChanges(...)");
            Iterable iterable2 = iterable;
            Pair initial$iv = TuplesKt.to((Object)new ArrayList(), (Object)new ArrayList());
            boolean $i$f$fold = false;
            Pair accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void item;
                FileChange fileChange = (FileChange)element$iv;
                Pair pair = accumulator$iv;
                boolean bl = false;
                List modified = (List)pair.component1();
                List removed = (List)pair.component2();
                ChangeType changeType = item.getChangeType();
                switch (changeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[changeType.ordinal()]) {
                    case 1: 
                    case 2: {
                        File file = item.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                        modified.add(file);
                        break;
                    }
                    case 3: {
                        File file = item.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                        removed.add(file);
                        break;
                    }
                }
                accumulator$iv = TuplesKt.to((Object)modified, (Object)removed);
            }
            Iterable $this$getChangedFiles_u24lambda_u249 = iterable2 = accumulator$iv;
            boolean bl = false;
            changedFiles = (ChangedFiles)new ChangedFiles.Known((List)$this$getChangedFiles_u24lambda_u249.getFirst(), (List)$this$getChangedFiles_u24lambda_u249.getSecond(), false, 4, null);
        }
        return changedFiles;
    }

    private static final void androidLayoutResources$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void action$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChangeType.values().length];
            try {
                nArray[ChangeType.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.MODIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

