/*
 * Decompiled with CFR 0.152.
 */
package com.kanyun.kace.gradle;

import com.kanyun.kace.gradle.utils.ResourceIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/kanyun/kace/gradle/LayoutNodeItem;", "", "identifier", "Lcom/kanyun/kace/gradle/utils/ResourceIdentifier;", "xmlType", "", "(Lcom/kanyun/kace/gradle/utils/ResourceIdentifier;Ljava/lang/String;)V", "getIdentifier", "()Lcom/kanyun/kace/gradle/utils/ResourceIdentifier;", "viewId", "getViewId", "()Ljava/lang/String;", "viewNameWithPackage", "getViewNameWithPackage", "getXmlType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kace-gradle-plugin"})
public final class LayoutNodeItem {
    @NotNull
    private final ResourceIdentifier identifier;
    @NotNull
    private final String xmlType;

    public LayoutNodeItem(@NotNull ResourceIdentifier identifier, @NotNull String xmlType) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)xmlType, (String)"xmlType");
        this.identifier = identifier;
        this.xmlType = xmlType;
    }

    @NotNull
    public final ResourceIdentifier getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final String getXmlType() {
        return this.xmlType;
    }

    @NotNull
    public final String getViewNameWithPackage() {
        String string;
        block17: {
            block16: {
                if (!StringsKt.contains$default((CharSequence)this.xmlType, (CharSequence)".", (boolean)false, (int)2, null)) break block16;
                string = this.xmlType;
                break block17;
            }
            switch (this.xmlType) {
                case "WebView": {
                    string = "android.webkit.WebView";
                    break;
                }
                case "ViewStub": 
                case "TextureView": 
                case "View": 
                case "SurfaceView": {
                    string = "android.view." + this.xmlType;
                    break;
                }
                default: {
                    string = "android.widget." + this.xmlType;
                }
            }
        }
        return string;
    }

    @NotNull
    public final String getViewId() {
        return this.identifier.getName();
    }

    @NotNull
    public final ResourceIdentifier component1() {
        return this.identifier;
    }

    @NotNull
    public final String component2() {
        return this.xmlType;
    }

    @NotNull
    public final LayoutNodeItem copy(@NotNull ResourceIdentifier identifier, @NotNull String xmlType) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)xmlType, (String)"xmlType");
        return new LayoutNodeItem(identifier, xmlType);
    }

    public static /* synthetic */ LayoutNodeItem copy$default(LayoutNodeItem layoutNodeItem, ResourceIdentifier resourceIdentifier, String string, int n, Object object) {
        if ((n & 1) != 0) {
            resourceIdentifier = layoutNodeItem.identifier;
        }
        if ((n & 2) != 0) {
            string = layoutNodeItem.xmlType;
        }
        return layoutNodeItem.copy(resourceIdentifier, string);
    }

    @NotNull
    public String toString() {
        return "LayoutNodeItem(identifier=" + this.identifier + ", xmlType=" + this.xmlType + ')';
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = result * 31 + this.xmlType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayoutNodeItem)) {
            return false;
        }
        LayoutNodeItem layoutNodeItem = (LayoutNodeItem)other;
        if (!Intrinsics.areEqual((Object)this.identifier, (Object)layoutNodeItem.identifier)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.xmlType, (Object)layoutNodeItem.xmlType);
    }
}

