/*
 * Decompiled with CFR 0.152.
 */
package com.kanyun.kace.gradle;

import com.kanyun.kace.gradle.utils.PluginUtilsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c2\u0003J1\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000e\u00a8\u0006("}, d2={"Lcom/kanyun/kace/gradle/LayoutItem;", "", "destDir", "Ljava/io/File;", "layoutFile", "variantName", "", "kaePackagePrefix", "<init>", "(Ljava/io/File;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "getDestDir", "()Ljava/io/File;", "getLayoutFile", "getVariantName", "()Ljava/lang/String;", "kaePackage", "getKaePackage", "kaePackageDir", "getKaePackageDir", "layoutName", "getLayoutName", "targetDir", "getTargetDir", "targetViewExtensionDir", "getTargetViewExtensionDir", "targetFilePackageName", "getTargetFilePackageName", "targetFileName", "getTargetFileName", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "kace-gradle-plugin"})
public final class LayoutItem {
    @NotNull
    private final File destDir;
    @NotNull
    private final File layoutFile;
    @NotNull
    private final String variantName;
    @NotNull
    private final String kaePackagePrefix;

    public LayoutItem(@NotNull File destDir, @NotNull File layoutFile, @NotNull String variantName, @NotNull String kaePackagePrefix) {
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)layoutFile, (String)"layoutFile");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)kaePackagePrefix, (String)"kaePackagePrefix");
        this.destDir = destDir;
        this.layoutFile = layoutFile;
        this.variantName = variantName;
        this.kaePackagePrefix = kaePackagePrefix;
    }

    public /* synthetic */ LayoutItem(File file, File file2, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = "kotlinx.android.synthetic";
        }
        this(file, file2, string, string2);
    }

    @NotNull
    public final File getDestDir() {
        return this.destDir;
    }

    @NotNull
    public final File getLayoutFile() {
        return this.layoutFile;
    }

    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    private final String getKaePackage() {
        return this.kaePackagePrefix + '.' + this.variantName;
    }

    private final String getKaePackageDir() {
        return StringsKt.replace$default((String)this.getKaePackage(), (String)".", (String)"/", (boolean)false, (int)4, null);
    }

    private final String getLayoutName() {
        String string = this.layoutFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String[] stringArray = new String[]{"."};
        return (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
    }

    @NotNull
    public final File getTargetDir() {
        return new File(this.destDir, this.getKaePackageDir() + '/' + this.getLayoutName());
    }

    @NotNull
    public final File getTargetViewExtensionDir() {
        return new File(this.getTargetDir(), "view");
    }

    @NotNull
    public final String getTargetFilePackageName() {
        return this.getKaePackage() + '.' + this.getLayoutName();
    }

    @NotNull
    public final String getTargetFileName() {
        return PluginUtilsKt.toCamelCase(this.getLayoutName()) + ".kt";
    }

    @NotNull
    public final File component1() {
        return this.destDir;
    }

    @NotNull
    public final File component2() {
        return this.layoutFile;
    }

    @NotNull
    public final String component3() {
        return this.variantName;
    }

    private final String component4() {
        return this.kaePackagePrefix;
    }

    @NotNull
    public final LayoutItem copy(@NotNull File destDir, @NotNull File layoutFile, @NotNull String variantName, @NotNull String kaePackagePrefix) {
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)layoutFile, (String)"layoutFile");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)kaePackagePrefix, (String)"kaePackagePrefix");
        return new LayoutItem(destDir, layoutFile, variantName, kaePackagePrefix);
    }

    public static /* synthetic */ LayoutItem copy$default(LayoutItem layoutItem, File file, File file2, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            file = layoutItem.destDir;
        }
        if ((n & 2) != 0) {
            file2 = layoutItem.layoutFile;
        }
        if ((n & 4) != 0) {
            string = layoutItem.variantName;
        }
        if ((n & 8) != 0) {
            string2 = layoutItem.kaePackagePrefix;
        }
        return layoutItem.copy(file, file2, string, string2);
    }

    @NotNull
    public String toString() {
        return "LayoutItem(destDir=" + this.destDir + ", layoutFile=" + this.layoutFile + ", variantName=" + this.variantName + ", kaePackagePrefix=" + this.kaePackagePrefix + ')';
    }

    public int hashCode() {
        int result = this.destDir.hashCode();
        result = result * 31 + this.layoutFile.hashCode();
        result = result * 31 + this.variantName.hashCode();
        result = result * 31 + this.kaePackagePrefix.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayoutItem)) {
            return false;
        }
        LayoutItem layoutItem = (LayoutItem)other;
        if (!Intrinsics.areEqual((Object)this.destDir, (Object)layoutItem.destDir)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.layoutFile, (Object)layoutItem.layoutFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variantName, (Object)layoutItem.variantName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.kaePackagePrefix, (Object)layoutItem.kaePackagePrefix);
    }
}

