/*
 * Decompiled with CFR 0.152.
 */
package com.kanyun.kace.gradle.utils;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import java.io.File;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"getApplicationPackage", "", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "project", "Lorg/gradle/api/Project;", "mainSourceSet", "Lcom/android/build/gradle/api/AndroidSourceSet;", "manifestFile", "Ljava/io/File;", "parseXml", "Lorg/w3c/dom/Document;", "kace-gradle-plugin"})
public final class PackageUtilsKt {
    @NotNull
    public static final String getApplicationPackage(@NotNull BaseExtension androidExtension, @NotNull Project project, @NotNull AndroidSourceSet mainSourceSet) {
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mainSourceSet, (String)"mainSourceSet");
        File manifestFile = mainSourceSet.getManifest().getSrcFile();
        String applicationPackage = PackageUtilsKt.getApplicationPackage(androidExtension, manifestFile);
        if (applicationPackage == null) {
            project.getLogger().warn("Application package name is not present in the manifest file (" + manifestFile.getAbsolutePath() + ')');
            return "";
        }
        return applicationPackage;
    }

    private static final String getApplicationPackage(BaseExtension androidExtension, File manifestFile) {
        try {
            Method method = androidExtension.getClass().getDeclaredMethod("getNamespace", new Class[0]);
            Object result = method.invoke((Object)androidExtension, new Object[0]);
            if (result instanceof String && ((CharSequence)result).length() > 0) {
                return (String)result;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        try {
            return PackageUtilsKt.parseXml(manifestFile).getDocumentElement().getAttribute("package");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Document parseXml(File $this$parseXml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse($this$parseXml);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        return document;
    }
}

