/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener.single;

import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.single.PermissionListener;
import java.util.Arrays;
import java.util.Collection;

public class CompositePermissionListener
implements PermissionListener {
    private final Collection<PermissionListener> listeners;

    public CompositePermissionListener(PermissionListener ... permissionListenerArray) {
        this(Arrays.asList(permissionListenerArray));
    }

    public CompositePermissionListener(Collection<PermissionListener> collection) {
        this.listeners = collection;
    }

    @Override
    public void onPermissionGranted(PermissionGrantedResponse permissionGrantedResponse) {
        for (PermissionListener permissionListener : this.listeners) {
            permissionListener.onPermissionGranted(permissionGrantedResponse);
        }
    }

    @Override
    public void onPermissionDenied(PermissionDeniedResponse permissionDeniedResponse) {
        for (PermissionListener permissionListener : this.listeners) {
            permissionListener.onPermissionDenied(permissionDeniedResponse);
        }
    }

    @Override
    public void onPermissionRationaleShouldBeShown(PermissionRequest permissionRequest, PermissionToken permissionToken) {
        for (PermissionListener permissionListener : this.listeners) {
            permissionListener.onPermissionRationaleShouldBeShown(permissionRequest, permissionToken);
        }
    }
}

