/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener.single;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.single.BasePermissionListener;

public class DialogOnDeniedPermissionListener
extends BasePermissionListener {
    private final Context context;
    private final String title;
    private final String message;
    private final String positiveButtonText;
    private final Drawable icon;

    private DialogOnDeniedPermissionListener(Context context, String string, String string2, String string3, Drawable drawable) {
        this.context = context;
        this.title = string;
        this.message = string2;
        this.positiveButtonText = string3;
        this.icon = drawable;
    }

    @Override
    public void onPermissionDenied(PermissionDeniedResponse permissionDeniedResponse) {
        super.onPermissionDenied(permissionDeniedResponse);
        new AlertDialog.Builder(this.context).setTitle((CharSequence)this.title).setMessage((CharSequence)this.message).setPositiveButton((CharSequence)this.positiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.dismiss();
            }
        }).setIcon(this.icon).show();
    }

    public static class Builder {
        private final Context context;
        private String title;
        private String message;
        private String buttonText;
        private Drawable icon;

        private Builder(Context context) {
            this.context = context;
        }

        public static Builder withContext(Context context) {
            return new Builder(context);
        }

        public Builder withTitle(String string) {
            this.title = string;
            return this;
        }

        public Builder withTitle(@StringRes int n) {
            this.title = this.context.getString(n);
            return this;
        }

        public Builder withMessage(String string) {
            this.message = string;
            return this;
        }

        public Builder withMessage(@StringRes int n) {
            this.message = this.context.getString(n);
            return this;
        }

        public Builder withButtonText(String string) {
            this.buttonText = string;
            return this;
        }

        public Builder withButtonText(@StringRes int n) {
            this.buttonText = this.context.getString(n);
            return this;
        }

        public Builder withIcon(Drawable drawable) {
            this.icon = drawable;
            return this;
        }

        public Builder withIcon(@DrawableRes int n) {
            this.icon = this.context.getResources().getDrawable(n);
            return this;
        }

        public DialogOnDeniedPermissionListener build() {
            String string = this.title == null ? "" : this.title;
            String string2 = this.message == null ? "" : this.message;
            String string3 = this.buttonText == null ? "" : this.buttonText;
            return new DialogOnDeniedPermissionListener(this.context, string, string2, string3, this.icon);
        }
    }
}

