/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter.listener.single;

import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.single.PermissionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class CompositePermissionListener
implements PermissionListener {
    private final Collection<PermissionListener> listeners;

    public CompositePermissionListener(PermissionListener ... permissionListenerArray) {
        this(Arrays.asList(permissionListenerArray));
    }

    public CompositePermissionListener(Collection<PermissionListener> collection) {
        this.listeners = collection;
    }

    @Override
    public void onPermissionGranted(PermissionGrantedResponse permissionGrantedResponse) {
        Iterator<PermissionListener> iterator = ((CompositePermissionListener)((Object)iterator)).listeners.iterator();
        while (iterator.hasNext()) {
            ((PermissionListener)iterator.next()).onPermissionGranted(permissionGrantedResponse);
        }
    }

    @Override
    public void onPermissionDenied(PermissionDeniedResponse permissionDeniedResponse) {
        Iterator<PermissionListener> iterator = ((CompositePermissionListener)((Object)iterator)).listeners.iterator();
        while (iterator.hasNext()) {
            ((PermissionListener)iterator.next()).onPermissionDenied(permissionDeniedResponse);
        }
    }

    @Override
    public void onPermissionRationaleShouldBeShown(PermissionRequest permissionRequest, PermissionToken permissionToken) {
        Iterator<PermissionListener> iterator = ((CompositePermissionListener)((Object)iterator)).listeners.iterator();
        while (iterator.hasNext()) {
            ((PermissionListener)iterator.next()).onPermissionRationaleShouldBeShown(permissionRequest, permissionToken);
        }
    }
}

